#!/bin/sh

if [ ! -e /dev/rdr ]; then
echo No RAMDUMP found > /dev/kmsg
exit 0
fi

# Set variable upload_over: SD 1, USB-FTP 2
#
# FTP requires server to be connected
# so if SD-card is available using it is better.
# Check SD-card availability
if [ -e "/sdcard/lost+found" ]
then
 upload_over=1
else
 upload_over=2
fi

echo 6 > /proc/sys/kernel/printk
echo 0 > /sys/devices/system/cpu/cpu0/timer_irq_latency
echo =========================================== > /dev/kmsg
echo RAMDUMP prepared by U-boot in RAM found > /dev/kmsg
echo The normal startup ABORTED for RAMDUMP uploading ... > /dev/kmsg
echo Script $0 is running > /dev/kmsg
echo upload_over == $upload_over > /dev/kmsg

# Use fixed File-Name:
#  RDNAME=RAMDUMP0000
# Use File-Name with RAMDUMP_YYMMDD-HHMM:
RDNAME=RAMDUMP_$(date +%y%m%d-%H%M)

if [ $upload_over -eq 1 ]; then
  # Upload to SD-Card
  echo ...Upload to SD /mnt/external_sdcard/$RDNAME.* > /dev/kmsg
  #echo t > /dev/rdr  - default
  cp /dev/rdr /mnt/external_sdcard/$RDNAME.txt
  echo d > /dev/rdr
  cp /dev/rdr /mnt/external_sdcard/$RDNAME.gz
  result=$?
else
  # Upload to FTP server

  IP_ADDRESS=`getprop persist.mrvl.net.static_ip`
  FTP_SERV_IP=`getprop persist.mrvl.ramdump.host_ip`
  RAMDUMP_USER=`getprop persist.mrvl.ramdump.user`

  ifconfig usb0 $IP_ADDRESS netmask 255.255.255.0 up
  sleep 1

  echo ...Upload to FTP $FTP_SERV_IP USER $RAMDUMP_USER > /dev/kmsg
  loop=0
  while [ $loop -le 3 ]
  do
    echo t > /dev/rdr
    busybox ftpput -u $RAMDUMP_USER $FTP_SERV_IP $RDNAME.txt /dev/rdr
    result=$?
    if [ $result -eq 0 ]; then
      echo d > /dev/rdr
      busybox ftpput -u $RAMDUMP_USER $FTP_SERV_IP $RDNAME.gz /dev/rdr
      result=$?
    fi

    if [ $result -eq 0 ]; then
      # Uploaded with ok. Exit loop
      echo ...Upload $RDNAME to FTP finished succesfuly! > /dev/kmsg
      loop=1000
    else
      # No answer from server or error. Try again
      loop=$((loop+1))
      echo FTP uploading retry ... > /dev/kmsg
      sleep 1
    fi
  done
  if [ $loop -ne 1000 ]; then
	# Upload to FTP failed, save it to cache
	echo FTP upload failed > /dev/kmsg
	echo Upload to /cache/ > /dev/kmsg
	rm -f /cache/*
	echo t > /dev/rdr
	cp /dev/rdr /cache/$RDNAME.txt
	echo d > /dev/rdr
	cp /dev/rdr /cache/$RDNAME.gz
	result=$?
	 if [ $result -eq 0 ]; then
		echo Upload $RDNAME to /cache/ finished succesfuly! > /dev/kmsg
	fi
  fi
fi

echo RAMDUMP upload finished with $result ----- Re-Start ---- > /dev/kmsg
# Clear ramdump descriptor before restart
echo c > /dev/rdr
reboot
