#!/bin/sh

#add all kernel command line tokens to properties
egrep -or "[A-Z]+=[a-z0-9]+" /proc/cmdline | sed -e "s/^/ro.cmdline./g" -e "s/=/ /g" | xargs -n 2 setprop

#create COMCfg.prop file, in csv format
getprop | sed -e "s/\]: \[/,/g" -e "s/\]$//g" -ne "s/\[ro.mrvl.comm.\|\[persist.mrvl.comm.//gp" > /tmp/COMCfg.prop

#create symlink to COMCfg.prop in /NVM
if [ ! -h /NVM/COMCfg.prop ]; then
	ln -s /tmp/COMCfg.prop /NVM/COMCfg.prop
fi

#create SymLink to APP files for COM in /NVM

#option 1 - from ro.mrvl.link2NVM property
LINK2NVM_PARAM=$(getprop ro.mrvl.link2NVM | awk -F"," '{for (i=1;i<=NF;i++){print $i}}')
#option 2 - from link2NVM file
LINK2NVM_PARAM="$LINK2NVM_PARAM $(cat /system/etc/link2NVM)"

for file in $(echo $LINK2NVM_PARAM)	; do
	if [ ! -e /NVM/"$file" -a ! -h /NVM/"$file" ]; then
		ln -s /system/etc/"$file" /NVM/"$file"
	fi
done

#option 3 - from rf_files_# plugin file
RF_PLUGIN_NUM=$(getprop ro.cmdline.RFPL)
RF_PLUGIN_FILE="/system/etc/rf_files_$RF_PLUGIN_NUM"

RF_PLUGIN_PARAM=$(cat "$RF_PLUGIN_FILE")

for files in $(echo $RF_PLUGIN_PARAM) ; do
	SRC=$(echo $files | awk -F"," '{print $1}')
	DST=$(echo $files | awk -F"," '{print $2}')

	if [ ! -e /NVM/"$DST" -a ! -h /NVM/"$DST" -a -e /system/etc/"$SRC" ]; then
		ln -s /system/etc/"$SRC" /NVM/"$DST"
	fi
done

