#!/xbin/sh

#################################################
# pakcet gen script
#
# generate ipv4 udp packets targeted to a
# registered network interface (e.g. usb, uap, etc.)
# run with -h option for help
#
# author: Tomer Eliyahu (tomere@marvell.com)
#################################################

#default params
count=0				#endless
delay=0				#no delay between packets
ip_addr="192.168.1.100";	#ip address
mac_addr="6c:88:14:62:99:c0";	#mac address
interface="uap0"		#target interface
dst_port_min=5000		#udp destination port min
dst_port_max=6000		#udp destination port max
pkt_size=1491			#packet size

rand=0;				#not random

print_params()
{
	echo "pkgen script parameters"
	echo "======================="
	echo interface $interface, packet size $pkt_size, count $count, delay $delay
	if [ $rand -eq 1 ]
	then
		echo randomize ip addresses and udp ports
	else
		echo ip_addr $ip_addr, mac_addr $mac_addr
		echo udp_dst_min $dst_port_min, udp_dst_max $dst_port_max
	fi
}

usage()
{
	echo "usage: $0 [options]"
	echo "OPTIONS"
	echo "-f  <i/f>   [interface - target interface]"
	echo "-s  <size>  [size  - packet size in bytes]"
	echo "-c  <count> [count - number of packets to generate, 0 for endless]"
	echo "-d  <delay> [delay - ns delay between packets]"
	echo "-i  <ip>    [ip    - ip address of target device]"
	echo "-m  <mac>   [mac   - mac address of target device]"
	echo "-h          [show help]"
	echo "-r          [randomize ip src, ip dst, src port, dst port]"
	exit
}

while getopts f:c:d:i:m:s:p:hr option
do
	case "${option}"
	in
		f) interface=${OPTARG};;
		c) count=${OPTARG};;
		d) delay=${OPTARG};;
		i) ip_addr=${OPTARG};;
		m) mac_addr=${OPTARG};;
		s) pkt_size=${OPTARG};;
		p) dst_port_min=${OPTARG}
		   dst_port_max=${OPTARG};;
		r) rand=1;;
		h) usage
		   exit 1;;
		\?) echo "Invalid option: -$OPTARG" >&2
		    echo "for help, run $0 -h"
		    exit 1;;
		:)  echo "Option -$OPTARG requires an argument." >&2
		    echo "for help, run $0 -h"
		    exit 1;;
	esac
done

print_params

insmod /lib/modules/pktgen.ko
sleep 1

#Uncomment this lines to disable ICMPs from target
#echo 0xFFFFFFFF >/proc/sys/net/ipv4/icmp_ratelimit
#echo 0xFFFFFFFF >/proc/sys/net/ipv4/icmp_ratemask

echo "rem_device_all" > /proc/net/pktgen/kpktgend_0
echo "add_device $interface" > /proc/net/pktgen/kpktgend_0
sleep 1

echo "count $count" > /proc/net/pktgen/$interface
echo "clone_skb 0" > /proc/net/pktgen/$interface
echo "pkt_size $pkt_size" > /proc/net/pktgen/$interface
echo "delay $delay" > /proc/net/pktgen/$interface
echo "dst_min $ip_addr" > /proc/net/pktgen/$interface
echo "dst_max $ip_addr" > /proc/net/pktgen/$interface
echo "src_min 192.168.1.155" > /proc/net/pktgen/$interface
echo "src_max 192.168.1.254" > /proc/net/pktgen/$interface
echo "dst_mac $mac_addr" > /proc/net/pktgen/$interface
echo "udp_dst_min  $dst_port_min" > /proc/net/pktgen/$interface
echo "udp_dst_max  $dst_port_max" > /proc/net/pktgen/$interface

if [ $rand -eq 1 ]
then
	echo "flag IPSRC_RND " > /proc/net/pktgen/$interface
	echo "flag IPDST_RND" > /proc/net/pktgen/$interface
	echo "flag UDPSRC_RND" > /proc/net/pktgen/$interface
	echo "flag UDPDST_RND" > /proc/net/pktgen/$interface
fi

echo starting...

echo "start" > /proc/net/pktgen/pgctrl
cat /proc/net/pktgen/$interface

#reload pktgen KO
sleep 1
rmmod /lib/modules/pktgen.ko
