
# init the data base used by the mipsram ACAT's module
# (A.K.A CT Panalyzer).

##########################
# variables definitions: #
##########################
BASEDIR=$(dirname $0)
TEMP_DIR=/tmp/mrvlsys
db_file_path=${TEMP_DIR}/mipsram_metadata.db
irqs_path=/proc/interrupts
softirqs_path=/proc/softirqs
product_point_path=/sys/devices/system/cpu/cpu0/duty_cycle
kernel_cmdline=/proc/cmdline
kernel_symbols=/proc/kallsyms
mtsd_tasklist=${TEMP_DIR}/tasklist.txt
ini_file_path=$BASEDIR/mipsram.ini

######################
# functions section: #
######################
init_db()
{
	echo "mipsram streaming data base:" > $db_file_path
}

append_to_db()
{
	path=$1
	delimiter=$2
	echo "[$delimiter]" >> $db_file_path
	cat $path >> $db_file_path
}

append_tasks_list()
{
	delimiter=$1
	echo "[$delimiter]" >> $db_file_path
	ps -lT >> $db_file_path
}

append_debug_section()
{
	delimiter=$1
	echo "[$delimiter]" >> $db_file_path
	append_to_db $irqs_path "irqs since boot"
	append_to_db $softirqs_path "softirq since boot"
	append_to_db $kernel_cmdline "kernel cmdline"
}

###############
# the script: #
###############
init_db
append_to_db $ini_file_path "ini file section"
append_to_db $product_point_path "product points frequencies"
append_tasks_list "kernel tasklist"
append_to_db $mtsd_tasklist "mtsd tasklist"
append_to_db $kernel_symbols "kernel symbols"
append_debug_section "streaming debug section"
echo "Done"
