#!/system/xbin/sh
myself=${0##*/}
# Create tiny_logs.tgz and full_logs.tgz inside event directory

if [ -z "$1" ] ; then
	echo "$myself: Wrong parameter..." > /dev/kmsg
	exit 1
fi

EVENT_DIR=$1

cd $EVENT_DIR || exit 1
if ls RAMDUMP* ; then
    mkdir full_logs
    cp Spy.txt full_logs/
    cp description.txt full_logs/
    mv RAMDUMP* full_logs/
fi
mkdir tiny_logs
mv `find -maxdepth 1 -type f` tiny_logs/
cp tiny_logs/Spy.txt .
if [ -d tiny_logs ] ; then
    tar cv tiny_logs | gzip -1 - > tiny_logs.tgz
    rm -rf tiny_logs
fi
if [ -d full_logs ] ; then
	tar cv full_logs | gzip -1 - > full_logs.tgz
    rm -rf full_logs
fi

# mark folder with OFFLINE file (means ready for upload in hawk apps)
if [ -f $EVENT_DIR/tiny_logs.tgz -o -f $EVENT_DIR/full_logs.tgz ]  ; then
	touch $EVENT_DIR/OFFLINE
fi
sync
