#!/bin/sh
#       cpddrdump.sh LOG_DIR
# Called by EEH upon assert and uses the EEH utility
#     -S[0za] offs offs [offs]... outFile
# where
#  "offs" are HEX (0x not required) in range 0..1000000
# [0za] are "ZeroPad the area", "zip out file", "append the area to row file"
# Examples:
#  eeh -S0  0 280000 700000 C00000 E00000 outF
#     14MB dump of: (0..280000 ZEROed) + (280000..700000 dump) +
#      (700000..C00000 ZEROed) + (C00000..E00000 dump)
#  eeh -S0  0 280000 700000 C00000 E00000 outF
#     14MB dump of: (0..280000 dump) + (280000..700000 ZEROed) +
#      (700000..C00000 dump) + (C00000..E00000 ZEROed)
#  eeh -S0z 0 280000 700000 C00000 E00000 outF
#     14MB ZIPped of: (0..280000 ZEROed) + (280000..700000 dump) +
#      (700000..C00000 ZEROed) + (C00000..E00000 dump)
#-------

LOG_DIR=$1
BIN_DIR=$LOG_DIR
FL_BIN=$BIN_DIR/com_DDR_14MB.bin
OUT_GZ=$LOG_DIR/com_DDR_14MB.gz

eeh -Sz0  0 280000 700000 C00000 E00000 $OUT_GZ
exit 0

#eeh -S0  0 280000 700000 C00000 E00000 $FL_BIN
#exit 0

echo ----- Create $FL_BIN with "append" ---------
OUT_TGZ=$LOG_DIR/com_DDR_14MB.tgz
# Zero-Pad  MSA size 0x280000= 0x8000*5 = 524288 * 5 = 2621440
dd if=/dev/zero bs=524288 count=5 of=$FL_BIN

# Dump MSA-Heap DDR area (com_heapMSA.bin)
/marvell/tel/eeh -S 280000  80000 $FL_BIN append

# Dump extra CP DDR RW valuable 4MB
/marvell/tel/eeh -S 300000 400000 $FL_BIN append

# Zero-Pad  non-valuable size 5MB=1048576*5
dd if=/dev/zero bs=524288 count=10 >> $FL_BIN

# Dump COMM Heap DDR 2MB
/marvell/tel/eeh -S C00000 200000 $FL_BIN append

#echo ----- Create  $OUT_TGZ ---------
#busybox tar cvz -f $OUT_TGZ $FL_BIN
