#!/bin/sh

srczip=$1

filename=$(basename "$srczip")
extention="${filename##*.}"
#in case the input file is not a ZIP file, we assume full SW upgrade
if [ "$extention" != "zip" ]; then
	echo "update from fbf file"
	echo "FOTA REBOOT."
	eeh -F 0
	exit 0
fi

#input is a ZIP file, we assume this is Android FOTA package.
if [ -z "$srczip" -o  ! -f $srczip ];then
	echo "File not found \"$srczip\". Please provide valid file."
	exit 1
fi

srczip_md5="$2"
if [ -z "$2" ];then
	echo "FOTA md5 signature missing - skip test."
else
	md5=`md5sum $srczip |  cut -d " " -f 1`
	if [ "$md5" != `cat $srczip_md5 | cut -d " " -f 1` ]; then
		echo "FOTA image is incorrect,update failed"
		exit 1
	else
		echo "FOTA image md5 OK."
	fi
fi
mkdir -p /cache/recovery
echo "--update_package=$srczip" > /cache/recovery/command
# Disable PANIC DRAW after we kill telephony processes
echo 1 > /sys/module/seh/parameters/hawk_fota_active
sync

# DO NOT CHANGE bellow print - since User Test APK parses it.
echo "FOTA REBOOT."
eeh -F 1
