#!/bin/sh -x

get_cidr_mask() {
#	case "$1" in
#		255.0.0.0)     echo '/8'  ;;
#		255.240.0.0)   echo '/12' ;;
#		255.255.0.0)   echo '/16' ;;
#		255.255.255.0) echo '/24' ;;
#		*)             ;;
#	esac
	echo '/24'
}

parse_ipv4() {
	cmd="$1"
	iface="usb0"
	ip="$2"
	mask="$3"
	cidr_mask=`get_cidr_mask "$mask"`

	gw="$4"

	shift=4
}

parse_ipv6() {
	iface="usb0"
	cmd="$1"
	ip="$2"
	if [ -n "$3" ]; then
		gw="$3"
		cid="$4"
		config_ipv6="$5"
		shift=5
	else
		shift=2
	fi
}

write_dns() {
	dns=
	if [ "$1" != "0.0.0.0" ]; then
		dns="nameserver $1"
		cfg set prefer_dns_auto="$1"
		if [ "$2" != "0.0.0.0" ]; then
			dns="${dns}\nnameserver $2"
			cfg set standby_dns_auto="$2"
		fi
		echo -e "$dns" > /etc/resolv.conf
		echo -e "$dns" > /etc_ro/resolv.conf
	fi
}

iface=usb0

echo "$@"
case "$1" in
	connect) # $0 connect IP MASK GW [ DNS1 DNS2 ]
		ppp=`cfg get ppp_status`
		echo "----------------------------$ppp---------------------------------" 
		if [ "$ppp" != "ppp_connected" ]; then
			parse_ipv4 "$@"
		shift $shift
			ip addr add "${ip}${cidr_mask}" dev "$iface"
			ip route add default via "$gw" dev "$iface"
		write_dns "$1" "$2"
		cfg set wan_ipaddr="${ip}"
		cfg set wan_gateway="$gw"
		cfg set ppp_status=ppp_connected
			ip addr del 192.168.51.149/24 dev usb0
			ip addr add 192.168.51.149/24 dev usb0
		# added by ZTE
		iptables -t nat -F POSTROUTING
		iptables -t nat -A POSTROUTING -o $iface -j MASQUERADE
		fi
		;;

	connect6) # $0 connect6 IP GW cid
		parse_ipv6 "$@"
		shift $shift
		if [ "$config_ipv6" == "yes" ]; then
		    ip addr add "$ip" dev "$iface"
		fi
		cfg set ppp_status=ppp_connected
		#ip -6 neigh flush nud perm dev "$iface"
		#ip -6 neigh add "$gw" lladdr "00:ff:33:00:00:0$cid" dev "$iface"
		#ip -6 route add default dev "$iface"
#		ip -6 route add default via "$gw" dev "$iface"
		;;

	disconnect) # $0 disconnect OLDIP OLDMASK OLDGW [ NEWGW DNS1 DNS2 ]
		parse_ipv4 "$@"
		shift $shift
		ip addr del "${ip}${cidr_mask}" dev "$iface"
		ip route del default via "$gw" dev "$iface"
		if [ "$1" != "0.0.0.0" ]; then
			route add default gw "$1"
			write_dns "$2" "$3"
		fi
		cfg set wan_ipaddr="0.0.0.0"
		cfg set wan_gateway="0.0.0.0"
		cfg set prefer_dns_auto="0.0.0.0"
		cfg set standby_dns_auto="0.0.0.0"
		cfg set ppp_status=ppp_disconnected
		;;

	disconnect6) # $0 disconnect6 IP
		# Flush all IF global ipv6 addresses
		ip -6 addr flush scope global "$iface"
		# need to clear WAN IPv6 WebUI address here
		cfg set ppp_status=ppp_disconnected
		;;

	static) # $0  static IP/NET
		ip addr flush dev "$iface"
		ip route flush dev "$iface"
		ip addr add "$2" brd + dev "$iface"
		ifconfig "$iface" up

		# Using sed in order not to depend on awk
		if [ -e "/etc/network/interfaces" ]; then
			sed -n '/iface '"$iface"' inet dhcp/ {
				: skip_line;
				n;
				/iface/b break;
				b skip_line;
			};
			: break;
			p' -i /etc/network/interfaces
		fi
		#added by gaofei10139719 to start adb @2014.9.28 begin
		module_gw="192.168.51.1"
		if [ -e "/tmp/module_gw" ]; then
			echo "file /tmp/module_gw exists!"
			module_gw=`cat /tmp/module_gw exists`
			echo "module_gw=[$module_gw]"
			cfg set module_gw=$module_gw
		fi
		adb connect $module_gw
		cfg set adb_status=adb_connected
		adb_status=`cfg get adb_status`
		echo "adb_status=[$adb_status]"
		#added by gaofei10139719 to start adb @2014.9.28 end
		
		#push something to module begin
		adb push /etc_rw/config/phone_limit.xml  /data
		#push something to module end
		;;
		
	is_hwaddr_saved) # $0 is_hwaddr_saved
		# Using sed in order not to depend on awk
		if [ -e "/etc/network/interfaces" ]; then
			! sed -n '/iface '"$iface"'/ {
				: skip_line;
				n;
				/hwaddr/q1;
				/iface/q0;
				b skip_line;
			}' </etc/network/interfaces
		fi
		;;

	is_connected) # $0 is_connected
		connection_status=`cfg get ppp_status`
		! echo "$connection_status" | grep -cq "_connect"
		;;
esac
