#!/bin/sh
#

product_type=`cfg get product_type`
mtu=`cfg get mtu`
if [ "$mtu" == "" ] ; then
	mtu=1500
fi
radvd_zte_conf="/tmp/radvd-zte.conf"
dhcp6s_zte_conf="/tmp/dhcp6s-zte.conf"
npd6_zte_conf="/tmp/npd6.conf"
ipv6_route_del_sh_file="/tmp/ipv6_route_del.sh"
ppp_status_now=`cfg get ppp_status`

wan_ipv6_addr=`cfg get ipv6_wan_ipaddr`
wan_ipv6_addr_full=""
wan_ipv6_addr_simple=""
ipv6_prefix=""
ipv6_prefix_len=64

ipv6_prefer_dns=`cfg get ipv6_prefer_dns_auto`
ipv6_standby_dns=`cfg get ipv6_standby_dns_auto`

wan_dev_name="rmnet_data0"
lan_dev_name="bridge0"
usb_lan_name="rndis0"

usb_flag="0"

get_lan_dev_name()
{
if [ "NO_DRIVER_DATA_CARD" = "$product_type" -o "DRIVER_DATA_CARD" = "$product_type" ]
then
 while [ "$usb_flag" == "0" ]
  do
	usb_flag=`cat /sys/class/android_usb/android0/zte_usb_rndis_ecm_net`
	if [ "$usb_flag" == "0" ] ; then
    sleep 1
    echo "ipv6_init_radvd.sh: wait zte_usb_rndis_ecm_net file ok ..."
	elif [ "$usb_flag" == "1" ] ; then
	lan_dev_name="usb0"
	usb_lan_name="usb0"
	elif [ "$usb_flag" == "2" -o "$usb_flag" == "4" ] ; then
	lan_dev_name="ecm0"
	usb_lan_name="ecm0"
	elif [ "$usb_flag" == "3" ] ; then
	lan_dev_name="rndis0"
	usb_lan_name="rndis0"
	else
	lan_dev_name="bridge0"
	fi
  done	
  echo "lan_dev_name: $lan_dev_name"
else
  lan_dev_name="bridge0"
fi
}

get_ipv6_dns_info()
{
    # ipv6 dns set
    ipv6_dns_mode=`cfg get ipv6_dns_mode`
    echo "ipv6_dns_mode: $ipv6_dns_mode"

    if [ "$ipv6_dns_mode" = "auto" ];then
      ipv6_prefer_dns=`cfg get ipv6_prefer_dns_auto`
      ipv6_standby_dns=`cfg get ipv6_standby_dns_auto`
    elif [ "$ipv6_dns_mode" = "manual" ];then
      ipv6_prefer_dns=`cfg get  ipv6_prefer_dns_manual`
      ipv6_standby_dns=`cfg get ipv6_standby_dns_manual`
    fi
}

set_dhcp6s_zte_conf()
{
    ip6_ip_br=`ifconfig $lan_dev_name | grep inet6 | awk '{print $3}'| sed 's/\/64//g'`
    echo "interface $lan_dev_name" > $dhcp6s_zte_conf
    echo "{" >> $dhcp6s_zte_conf
    echo "    allow rapid-commit;" >> $dhcp6s_zte_conf
    echo "    send information-only;" >> $dhcp6s_zte_conf
    if [ -n "$ip6_ip_br" ]&& [ "$ip6_ip_br" != "::" ];then
      echo "    option dns_servers $ip6_ip_br;" >> $dhcp6s_zte_conf
    fi

    echo "    link AAA" >> $dhcp6s_zte_conf
    echo "    {" >> $dhcp6s_zte_conf
    echo "    };" >> $dhcp6s_zte_conf
    echo "};" >> $dhcp6s_zte_conf
}

old_set_radvd_zte_conf_old()
{
    echo "interface $lan_dev_name" > $radvd_zte_conf
    echo "{" >> $radvd_zte_conf
    echo "    AdvSendAdvert on;" >> $radvd_zte_conf
    echo "    MinRtrAdvInterval 10;" >> $radvd_zte_conf
    echo "    MaxRtrAdvInterval 30;" >> $radvd_zte_conf
    echo "    AdvOtherConfigFlag on;" >> $radvd_zte_conf
    echo "    AdvLinkMTU $mtu;" >> $radvd_zte_conf
    echo "" >> $radvd_zte_conf
    echo "    prefix $ipv6_prefix::/$ipv6_prefix_len" >> $radvd_zte_conf
    echo "    {" >> $radvd_zte_conf
    echo "        AdvOnLink on;" >> $radvd_zte_conf
    echo "        AdvAutonomous on;" >> $radvd_zte_conf
    echo "        AdvRouterAddr off;" >> $radvd_zte_conf
    echo "" >> $radvd_zte_conf
    echo "        AdvValidLifetime 65535;" >> $radvd_zte_conf
    echo "        AdvPreferredLifetime 32;" >> $radvd_zte_conf
    echo "    };" >> $radvd_zte_conf
    echo "};" >> $radvd_zte_conf
    chmod 755 $radvd_zte_conf
}

set_radvd_zte_conf()
{
    echo "interface $lan_dev_name" > $radvd_zte_conf
    echo "{" >> $radvd_zte_conf
    echo "    AdvSendAdvert on;" >> $radvd_zte_conf
    echo "    MinRtrAdvInterval 300;" >> $radvd_zte_conf
    echo "    MaxRtrAdvInterval 600;" >> $radvd_zte_conf
    echo "    AdvDefaultPreference low;" >> $radvd_zte_conf
    echo "    AdvHomeAgentFlag off;" >> $radvd_zte_conf
    echo "    AdvOtherConfigFlag on;" >> $radvd_zte_conf
    echo "    AdvLinkMTU $mtu;" >> $radvd_zte_conf

    echo "" >> $radvd_zte_conf
    echo "    prefix $ipv6_prefix::/$ipv6_prefix_len" >> $radvd_zte_conf
    echo "    {" >> $radvd_zte_conf
    echo "        AdvOnLink on;" >> $radvd_zte_conf
    echo "        AdvAutonomous on;" >> $radvd_zte_conf
    echo "        DeprecatePrefix on;" >> $radvd_zte_conf
    echo "" >> $radvd_zte_conf
    echo "    };" >> $radvd_zte_conf
    echo "};" >> $radvd_zte_conf
    chmod 755 $radvd_zte_conf
}

set_npd6_zte_conf()
{
    echo > $npd6_zte_conf
    echo "prefix = $ipv6_prefix:" >> $npd6_zte_conf
    echo "interface = $wan_dev_name" >> $npd6_zte_conf
    echo "prefix = $ipv6_prefix:" >> $npd6_zte_conf
    echo "interface = $lan_dev_name" >> $npd6_zte_conf
    echo >> $npd6_zte_conf
    echo "#prefix=2001:b010:6100:1201:" >> $npd6_zte_conf
    echo "#interface = mlan0" >> $npd6_zte_conf
    echo "#prefix=2001:b010:6100:1201:" >> $npd6_zte_conf
    echo "#interface = br0" >> $npd6_zte_conf
    echo "listtype = none" >> $npd6_zte_conf
    echo "listlogging = off" >> $npd6_zte_conf
    echo "collectTargets = 100" >> $npd6_zte_conf
    echo "linkOption = false" >> $npd6_zte_conf
    echo "ignoreLocal = true" >> $npd6_zte_conf
    echo "routerNA = true" >> $npd6_zte_conf
    echo "maxHops = 255" >> $npd6_zte_conf
    echo "pollErrorLimit = 20" >> $npd6_zte_conf
}

set_tr069_radvd_para()
{
	cfg set radvd_slaac_enable=1
	cfg set radvd_maxrtradvinterval=600
	cfg set radvd_minrtradvinterval=300
	cfg set radvd_advmangedflag_dhcp=0
	cfg set radvd_advotherconfigflag_dhcp=0
	cfg set radvd_prefix_preferred_lifetime=14400
	cfg set radvd_prefix_valid_lifetime=86400

	cfg set ipv6_address_assign_type=SLAAC
	cfg set ipv6_prefix_origin_type=RA

	cfg set ipv6_wan_prefix_info=$ipv6_prefix
	cfg set radvd_prefix_info=$ipv6_prefix::/64
}

## sh run start here
if echo $ppp_status_now | grep -q ipv6
then
    echo "$0: ipv6 connected"
else
    echo "$0: ipv6 not connected, exit"
    exit
fi

# get usb_lan_name and lan_dev_name
get_lan_dev_name

# here router_msg will gen new /tmp/ipv6_addr_full.txt
rm -fr /tmp/ipv6_addr_full.txt
router_msg ipv6_addr_convert $wan_ipv6_addr

wan_ipv6_addr_full=`cat /tmp/ipv6_addr_full.txt`

echo "$0: wan_ipv6_addr_full [$wan_ipv6_addr_full]"

ipv6_prefix=`echo $wan_ipv6_addr_full | cut -b 1-19`
wan_ipv6_addr_processed=`echo $ipv6_prefix | sed 's/://g'`
echo "$0: wan_ipv6_addr_processed [$wan_ipv6_addr_processed]"
wan_dev_name=`cat /proc/net/if_inet6 | grep $wan_ipv6_addr_processed | awk '{print $6}'`

echo "$0: wan_dev_name is [$wan_dev_name], prefix[$ipv6_prefix]"

echo 2 > /proc/sys/net/ipv6/conf/$wan_dev_name/accept_ra
echo 2 > /proc/sys/net/ipv6/conf/all/proxy_ndp
echo 2 > /proc/sys/net/ipv6/conf/all/forwarding

ip -6 route add default dev $wan_dev_name
ip -6 route del $ipv6_prefix::/$ipv6_prefix_len dev $wan_dev_name
ip -6 route add $ipv6_prefix::/$ipv6_prefix_len dev $lan_dev_name

echo "#!/bin/sh" > $ipv6_route_del_sh_file
echo "ip -6 route del default dev $wan_dev_name" >> $ipv6_route_del_sh_file
echo "ip -6 route del $ipv6_prefix::/$ipv6_prefix_len dev $lan_dev_name" >> $ipv6_route_del_sh_file

echo "$0: route done, will run radvd"

get_ipv6_dns_info
mkdir -p /var/lib/dhcpv6

set_npd6_zte_conf
set_radvd_zte_conf
set_dhcp6s_zte_conf

killall npd6 2>/dev/null
killall radvd
killall dhcp6s

#wan_ipv6_addr_simple=`ifconfig $wan_dev_name | grep inet6 | grep Global | head -n 1 | awk '{print $3}'`
#echo "wan_ipv6_addr_simple: $wan_ipv6_addr_simple"

ip6_route_check_sh="/tmp/ipv6_route_check.sh"
ip6_route_check_flag="/tmp/ipv6_route_check.flag"

rm -fr $ip6_route_check_sh
rm -fr $ip6_route_check_flag

# avoid sh keep running... rm too fast and create too fast
sleep 4

# create a new flag for check sh
echo "start" > $ip6_route_check_flag

# create route check sh
echo "#!/bin/sh" > $ip6_route_check_sh
# here we check flag
echo "while [ -f \"$ip6_route_check_flag\" ]" >> $ip6_route_check_sh
echo "do" >> $ip6_route_check_sh
echo "  sleep 3" >> $ip6_route_check_sh
#echo "  if ip -6 route | grep -q \"$ipv6_prefix::/$ipv6_prefix_len dev $wan_dev_name\"" >> $ip6_route_check_sh
#echo "  then" >> $ip6_route_check_sh
#echo "    echo del wan route" >> $ip6_route_check_sh
echo "    ip -6 route del $ipv6_prefix::/$ipv6_prefix_len dev $wan_dev_name 1>/dev/null 2>&1" >> $ip6_route_check_sh
echo "    ip -6 route add $ipv6_prefix::/$ipv6_prefix_len dev $lan_dev_name 1>/dev/null 2>&1" >> $ip6_route_check_sh
#echo "  else" >> $ip6_route_check_sh
#echo "    echo no wan route" >> $ip6_route_check_sh
#echo "  fi" >> $ip6_route_check_sh
echo "done" >> $ip6_route_check_sh
echo "echo no $ip6_route_check_flag, exit" >> $ip6_route_check_sh

sh $ip6_route_check_sh &

# here we wait lan ready
while [ ! -d "/sys/class/net/$lan_dev_name" ]
 do
  sleep 1
  echo "ipv6_init.sh: wait $lan_dev_name ..."
done

echo "ipv6_init.sh: $lan_dev_name exist, go ..."

dhcp6s -dDf -c $dhcp6s_zte_conf $lan_dev_name &
npd6 -c $npd6_zte_conf -l /tmp/npd6.log &
radvd -C $radvd_zte_conf &

set_tr069_radvd_para
# here we drop radish, using dhcp6s for dns info.
# killall -9 radish
# radish -k -b $wan_dev_name -i $wan_dev_name -x -i $lan_dev_name -x > /dev/null 2>&1 &

echo "ipv6_init.sh: done ..."
clat_func_switch=`cfg get clat_func_switch`
if [ "1" == "$clat_func_switch" ]
then
	echo ready to start clat
	sh /usr/zte/zte_conf/scripts/tayga.sh 1 &
fi
# we will call ipv6_tini.sh to undo 
