﻿/**
 * setting--device seeting--USSD module
 * 
 * @module ussd
 * @class ussd
 */
define([ 'jquery', 'service', 'knockout'], function($, service, ko) {
	
    /**
     * @class USSDInformationViewModel
     * @constructor
     */
	function USSDInformationViewModel() {
		var self = this;
		self.operateCommand = ko.observable();
		
		self.activate = function(){
			self.operateCommand("*141*6*5*3*1#");
			
			sendToNet();
		}
		
		self.deactivate = function(){
			self.operateCommand("*141*6*5*3*2#");
			
			sendToNet();
		}
		
		/**
		 * 发送USSD命令
		 * @method sendToNet
		 */
		function sendToNet(){
			showLoading();
			
			var params = {};
                params.operator = "ussd_send";
                params.strUSSDCommand = self.operateCommand();
				params.sendOrReply = "send";
			
			service.getUSSDResponse(params, function(result, content){
				hideLoading();
				if(result){
					showAlert(decodeMessage(content.data, true));
				}else{
					showAlert(content);
				}
			});
		};
	}
	
    /**
     * 初始化
     * @method init
     */
	function init() {
		var container = $('#container')[0];
		ko.cleanNode(container);
		var vm = new USSDInformationViewModel();
		ko.applyBindings(vm, container);
		
	}	
	
	return {
		init : init
	};
});