﻿/**
 * setting--device seeting--USSD module
 * 
 * @module ussd
 * @class ussd
 */
define([ 'jquery', 'service', 'knockout'], function($, service, ko) {
	
    /**
     * @class USSDInformationViewModel
     * @constructor
     */
	function USSDInformationViewModel() {
		var self = this;
		
		/**
		 * 发送USSD命令
		 * @method sendToNet
		 */
		self.sendToNet = function(){
			showLoading();
			
			var params = {};
                params.operator = "ussd_send";
                params.strUSSDCommand = $("#USSD_send").val()==""?"*141#":"*141*"+$("#USSD_send").val()+"#";
				params.sendOrReply = "send";
			
			service.getUSSDResponse(params, function(result, content){
				hideLoading();
				if(result){
					showAlert(decodeMessage(content.data, true));
				}else{
					showAlert(content);
				}
			});
		};
	}
	
    /**
     * 初始化
     * @method init
     */
	function init() {
		var container = $('#container')[0];
		ko.cleanNode(container);
		var vm = new USSDInformationViewModel();
		ko.applyBindings(vm, container);
		
		
		$("#frmUSSD").validate({
			submitHandler: function(){
				vm.sendToNet()
			},
			rules: {
				USSD_send: "any_digits"
			}
		});
		
	}	
	
	return {
		init : init
	};
});