﻿/**
 * setting--device seeting--USSD module
 * 
 * @module ussd
 * @class ussd
 */
define([ 'jquery', 'service', 'knockout'], function($, service, ko) {
	
	var currentOperation = {SEND:0, REPLY:1};
	var hasSended = false;
	var informationViewModel;
    /**
     * @class USSDInformationViewModel
     * @constructor
     */
	function USSDInformationViewModel() {
		var self = this;
		
		self.USSDLocation = ko.observable(currentOperation.SEND);
		self.USSDSend = ko.observable("");
		
		/**
		 * 发送USSD命令
		 * @method sendToNet
		 */
		self.sendToNet = function(){
			var command = self.USSDSend().toString();
			if ('' == command) {
				showAlert("ussd_error_input");
				return;
			}
			
			showLoading();
			
			var params = {};
                params.operator = "ussd_send";
                params.strUSSDCommand = command;
				params.sendOrReply = "send";
			
			service.getUSSDResponse(params, function(result, content){
				hideLoading();
				hasSended = true;				
				$("#ussd_send_div").hide();
				$("#ussd_content").show();
				if(result){
					var ussdValue=decodeMessage(content.data, true);
					self.USSDSend(ussdValue);
					$("#ussd_content").val(ussdValue);
					self.USSDLocation(currentOperation.REPLY);
				}else{
					showAlert(content);
					self.USSDLocation(currentOperation.SEND);
				}
			});
		};
		
		/**
		 * 回复USSD消息
		 * @method replyToNet
		 */
		self.replyToNet = function(){
			var command = self.USSDSend().toString();
			if ('' == command) {
				showAlert("ussd_error_input");
				return;
			}
			
			showLoading();
			
			var params = {};
                params.operator = "ussd_reply";
                params.strUSSDCommand = command;
				params.sendOrReply = "reply";
			
			service.getUSSDResponse(params, function(result, content){
				hideLoading();
				hasSended = true;
				$("#ussd_send_div").hide();
				$("#ussd_content").show();
				if(result){
					var ussdValue=decodeMessage(content.data, true);
					self.USSDSend(ussdValue);
					$("#ussd_content").val(ussdValue);
					self.USSDLocation(currentOperation.REPLY);
				}else{
					self.USSDLocation(currentOperation.REPLY);
					showAlert(content);
				}	
			});
		};
		
		/**
		 * 取消回复USSD消息
		 * @method noReplyCancel
		 */
		self.noReplyCancel = function(){
			service.USSDReplyCancel(function(result){
				if(result){
					self.USSDLocation(currentOperation.SEND);
				}else{
					showAlert("ussd_fail");
				}
			});
		};
		
		self.cancelUSSD = function(){
			if(self.USSDLocation()==currentOperation.SEND){
				self.USSDSend("");
			}else if(self.USSDLocation()==currentOperation.REPLY){
				self.USSDSend("");
				self.noReplyCancel();
			}
			$("#ussd_send_div").show();
			$("#ussd_content").hide();
		};
		
		self.ussdOperate = function(){
			if(hasSended){
				showAlert("ussd_error_input");
				return;
			}
			if(self.USSDLocation()==currentOperation.SEND){
				self.sendToNet();
			}else if(self.USSDLocation()==currentOperation.REPLY){
				self.replyToNet();
			}
		};
		
		self.showUssdOperate = function(num){
			if(hasSended){				
				self.USSDSend(num);
				hasSended = false;
			}else{
				self.USSDSend(self.USSDSend()+""+num);
			}
			$("#ussd_send_div").show();
			$("#ussd_content").hide();
		};
		
		self.delUssdOperate = function(){
			if(hasSended){				
				return;
			}
			var ussdSends = self.USSDSend();
			if(ussdSends.length>1){
				self.USSDSend(ussdSends.substr(0,ussdSends.length-1));
			}else{
				self.USSDSend("");
				if(self.USSDLocation()==currentOperation.REPLY){
					$("#ussd_send_div").hide();
					$("#ussd_content").show();
				}
			}
		};
		
		/**keyCodeToPrintableChar = {
			32:" ",48:"0", 49:"1", 50:"2", 51:"3", 52:"4", 53:"5", 54:"6", 55:"7", 56:"8",
			57:"9", 59:";", 61:"=", 65:"a", 66:"b", 67:"c", 68:"d",
			69:"e", 70:"f", 71:"g", 72:"h", 73:"i", 74:"j", 75:"k", 76:"l", 77:"m",
			78:"n", 79:"o", 80:"p", 81:"q", 82:"r", 83:"s", 84:"t", 85:"u", 86:"v",
			87:"w", 88:"x", 89:"y", 90:"z", 107:"+", 109:"-", 110:".", 188:",",
			190:".", 191:"/", 192:"'", 219:"[", 220:"\\", 221:"]", 222:"\""
		};**/
		keyCodeToPrintableChar = {
			32:" ", 59:";", 61:"=", 65:"a", 66:"b", 67:"c", 68:"d",
			69:"e", 70:"f", 71:"g", 72:"h", 73:"i", 74:"j", 75:"k", 76:"l", 77:"m",
			78:"n", 79:"o", 80:"p", 81:"q", 82:"r", 83:"s", 84:"t", 85:"u", 86:"v",
			87:"w", 88:"x", 89:"y", 90:"z", 107:"+", 109:"-", 110:".", 188:",",
			190:".", 191:"/", 192:"'", 219:"[", 220:"\\", 221:"]", 222:"\""
		};
		self.mergeKeyPressNum = function(keyEvent){
			var keyPressCode = keyEvent.charCode || keyEvent.keyCode;

			var num="";
			if(keyPressCode==96||keyPressCode==48){
				num=0;
			}else if(keyPressCode==97||keyPressCode==49){
				num=1;
			}else if(keyPressCode==98||keyPressCode==50){
				num=2;
			}else if(keyPressCode==99||keyPressCode==51){
				num=3;
			}else if(keyPressCode==100||keyPressCode==52){
				num=4;
			}else if(keyPressCode==101||keyPressCode==53){
				num=5;
			}else if(keyPressCode==102||keyPressCode==54){
				num=6;
			}else if(keyPressCode==103||keyPressCode==55){
				num=7;
			}else if(keyPressCode==104||keyPressCode==56){
				num=8;
			}else if(keyPressCode==105||keyPressCode==57){
				num=9;
			}else if(num==""){
				var keyName=keyCodeToPrintableChar[keyPressCode];
				if(keyName){
					return "false";
				}else{
					return "true";
				}
			}
			return num;
		};
	}
	
	function getInformationViewModel(){
		if(!informationViewModel){
			informationViewModel = new USSDInformationViewModel();
		}
		return informationViewModel;
	}

	function getUssdSendedFlag(){
		return hasSended;
	}
    /**
     * 初始化
     * @method init
     */
	function init() {
		var container = $('#container')[0];
		ko.cleanNode(container);
		informationViewModel = new USSDInformationViewModel();
		ko.applyBindings(informationViewModel, container);
		
	}	
	
	return {
		init : init,
		getInformationViewModel:getInformationViewModel,
		getUssdSendedFlag:getUssdSendedFlag
	};
});