/**
 * @module bluetooth setting
 * @class bluetooth setting
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore' ],

	function($, ko, config, service, _) {

		/**
		 * system bluetooth setting VM
		 * @class BluetoothSettingVM
		 */
		function BluetoothSettingVM() {
			var self = this;
			var info = getBluetoothSetting();
			self.isDataCard = config.DEVICE.toLowerCase().indexOf("datacard") !=-1;
			self.allowVisible = ko.observable(info.allow_visible);
			self.bluetooth_enable = ko.observable(info.bluetooth_switch);

			self.setAllowedVisible = function() {
				if(!$("#btAllowBtn").hasClass("disable")){
					var checkbox = $("#allowVisibleCheckbox:checked");
					if(checkbox && checkbox.length == 0 ){
						self.allowVisible("1");
					}else{
						self.allowVisible("0");
					}
				}
			};

			self.clear = function() {
				init();
			};

			self.deviceInfo = ko.observableArray([]);
			var templateColumns = [
				{ headerTextTrans:"station_number", rowText:"index", width:"10%"},
				{ headerTextTrans:"bt_device_mac", rowText:"dev_mac", width:"30%", needTrans: true},
				{ headerTextTrans:"bt_device_name", rowText:"dev_name", width:"20%", needTrans: true},
				{ columnType:"button1", rowText:"", headerTextTrans:"bt_device_unpair", width:"20%", needTrans: true},
				{ columnType:"button", rowText:"", headerTextTrans:"bt_device_action", width:"20%", needTrans: true}
			]
			self.gridTemplate = new ko.simpleGrid.viewModel({
				data:self.deviceInfo(),
				idName:"index",
				columns:templateColumns,
				pageSize: 100
			});

			self.deviceInfo1 = ko.observableArray([]);
			var templateColumns1 = [
				{ headerTextTrans:"station_number", rowText:"index", width:"10%"},
				{ headerTextTrans:"bt_device_mac", rowText:"dev_mac", width:"30%", needTrans: true},
				{ headerTextTrans:"bt_device_name", rowText:"dev_name", width:"30%", needTrans: true},
				{ columnType:"button", rowText:"", headerTextTrans:"bt_device_pair", width:"30%", needTrans: true}
			]
			self.gridTemplate1 = new ko.simpleGrid.viewModel({
				data:self.deviceInfo1(),
				idName:"index",
				columns:templateColumns1,
				pageSize: 100
			});

			self.searchAvailableDevice = function(){
				showLoading();
				service.searchAvailableDevice({}, function(result) {
					if (result.result == "success") {
						successOverlay();
						init();
					} else {
						errorOverlay();
					}
				});
			};

			self.save = function() {
				showLoading();
				var params = {};
				params.bluetooth_switch = self.bluetooth_enable();
				service.setBluetoothSetting(params, function(result) {
					if (result.result == "success") {
						self.clear();
						successOverlay();
					} else {
						errorOverlay();
					}
				});
			};

			self.saveAllow = function() {
				showLoading();
				var params = {};
				params.allow_visible = self.allowVisible();
				service.setBluetoothAllow(params, function(result) {
					if (result.result == "success") {
						self.clear();
						successOverlay();
					} else {
						errorOverlay();
					}
				});
			};
		}

		function refreshPairedDevicesList(VM) {
			var resultDevices = service.getPairedList().attachedDevices;
			$.each(resultDevices, function (i, val) {
				resultDevices[i].index = i + 1;
				if(resultDevices[i].dev_status =="1"){
					resultDevices[i].actionTrans = "disconnect";
				}else{
					resultDevices[i].actionTrans = "connect";
				}
				resultDevices[i].actionTrans1 = "bt_device_unpair";
				resultDevices[i].btnDisplay = true;
				resultDevices[i].enabled = true;
				resultDevices[i].btnDisplay1 = true;
				resultDevices[i].enabled1 = true;
				resultDevices[i].action = function () {
					doConnectOrDisconnectPairedBT(resultDevices[i].dev_mac,resultDevices[i].dev_status);
				};
				resultDevices[i].action1 = function () {
					doPairOrUnpairBT(resultDevices[i].dev_mac,0);
				};
			});
			VM.gridTemplate.data(resultDevices);
		}

		function refreshUnpairedDevicesList(VM) {
			var resultDevices = service.getAvailableList().attachedDevices;
			$.each(resultDevices, function (i, val) {
				resultDevices[i].index = i + 1;
				resultDevices[i].actionTrans = "bt_device_pair";
				resultDevices[i].btnDisplay = true;
				resultDevices[i].enabled = true;
				resultDevices[i].action = function () {
					doPairOrUnpairBT(resultDevices[i].dev_mac,1);
				};
			});
			VM.gridTemplate1.data(resultDevices);
		}

		var dirverCount = 0;
		function checkPairedConnectStatus(mac,flag) {
			var tempValue = flag;
			var tempMac = mac;
			service.getPairedList({},function(data){
				var pairedList = data.attachedDevices;
				var currIndex = 0;
				for(i=0;i<pairedList.length;i++){
					if(pairedList[i].dev_mac == tempMac){
						currIndex = i;
						break;
					}
				}
				if (pairedList[currIndex].dev_status == tempValue) {
					successOverlay();
					clearTimer();
					init();
				} else {
					if (dirverCount <= 10) {
						dirverCount = dirverCount + 1;
						addTimeout(function(){
							checkPairedConnectStatus(mac,flag);
						}, 1000);
					} else {
						errorOverlay();
						clearTimer();
						clearValidateMsg();
						init();
					}
				}
			})
		}

		function doConnectOrDisconnectPairedBT(mac,status){
			dirverCount = 0;
			showLoading();
			var params = {};
			params.curr_mac = mac;
			params.option_select = status == "1" ? 0:1;
			service.doConnectOrDisconnectPairedBT(params, function(result) {
				if (result.result == "success") {
					setTimeout(function () {
							setTimeout(function(){
								checkPairedConnectStatus(mac,params.option_select);
							},1000);
					});
				} else {
					errorOverlay();
				}
			});
		}

		function doPairOrUnpairBT(mac,status){
			showLoading();
			var params = {};
			params.curr_mac = mac;
			params.option_select = status;
			service.doPairOrUnpairBT(params, function(result) {
				if (result.result == "success") {
					successOverlay();
					init();
				} else {
					errorOverlay();
				}
			});
		}

		function getBluetoothSetting() {
			return service.getBluetoothSetting();
		}

		/**
		 * 初始化DmzSettingVM model
		 * @method init
		 */
		function init() {
			var container = $('#container');
			ko.cleanNode(container[0]);
			var vm = new BluetoothSettingVM();
			ko.applyBindings(vm, container[0]);
			refreshPairedDevicesList(vm);
			refreshUnpairedDevicesList(vm);
			addInterval(function () {
				refreshPairedDevicesList(vm);
				refreshUnpairedDevicesList(vm);
			}, 5000);
			$('#frmBlueTooth').validate({
				submitHandler : function() {
					vm.save();
				}
			});
			$('#frmAllowBlueTooth').validate({
				submitHandler : function() {
					vm.saveAllow();
				}
			});
		}

		return {
			init : init
		};
	});