﻿/**
 * setting--device seeting--USSD module
 * 
 * @module ussd
 * @class ussd
 */
define([ 'jquery', 'service', 'knockout'], function($, service, ko) {
	
    /**
     * @class USSDInformationViewModel
     * @constructor
     */
	function USSDInformationViewModel() {
		var self = this;
		
		self.pageState = {ussd_internet_main:0, ussd_internet_volume:1, ussd_internet_duration:2, ussd_internet_uncapped:3, ussd_internet_notsure:4};
		self.purchaseState = {low:0, medium:1, high:2};
		
		self.conditions = ko.observable("<a href='#' style='color:#0000ff;text-decoration:underline;'>Terms and Conditions</a>");
		
		self.ussd_internet_page = ko.observable(self.pageState.ussd_internet_main);
		self.USSDcommand = ko.observable(self.pageState.ussd_internet_main);
		self.currentState = ko.observable(self.purchaseState.low);
		
		/**
		 * 发送USSD命令
		 * @method sendToNet
		 */
		self.sendToNet = function(){
			showLoading();
			
			var params = {};
                params.operator = "ussd_send";
                params.strUSSDCommand = self.USSDcommand();
				params.sendOrReply = "send";
			
			service.getUSSDResponse(params, function(result, content){
				hideLoading();
				if(result){
					showAlert(decodeMessage(content.data, true));
				}else{
					showAlert(content);
				}
			});
		};		
		
		self.gotoNext = function(){
			var billingPreference = getBillingPreference("billingPreference");
			var billingPrefer = getBillingPreference("billingPrefer");
			if(billingPrefer=="1"){
				self.ussd_internet_page(self.pageState.ussd_internet_notsure);
				changeToState(self.purchaseState.low);
			}else{
				if(billingPreference=="0"){
					self.ussd_internet_page(self.pageState.ussd_internet_volume);
				}else if(billingPreference=="1"){
					self.ussd_internet_page(self.pageState.ussd_internet_duration);
				}else if(billingPreference=="2"){
					self.ussd_internet_page(self.pageState.ussd_internet_uncapped);
				}else if(billingPreference=="3"){
					self.ussd_internet_page(self.pageState.ussd_internet_notsure);
					changeToState(self.purchaseState.low);
				}
			}
		};
		
		self.back = function(){
			self.ussd_internet_page(self.pageState.ussd_internet_main);
		};
		
		self.purchase = function(){
			if(self.ussd_internet_page()==self.pageState.ussd_internet_volume){
				var termsValue = $("#termsChk1").attr("checked")==undefined?false:true;
				if(!termsValue){
					$("#errorDiv1").show();
					return;
				}
				var operation = getVolumeOperation(getBillingPreference("billingPreferenceVolume"),getBillingPreference("billingPreferenceChoose"));
				self.USSDcommand(operation);
				self.sendToNet();
			}else if(self.ussd_internet_page()==self.pageState.ussd_internet_duration){
				var termsValue = $("#termsChk2").attr("checked")==undefined?false:true;
				if(!termsValue){
					$("#errorDiv2").show();
					return;
				}
				var operation = getDurationOperation(getBillingPreference("durationChoose"));
				self.USSDcommand(operation);
				self.sendToNet();
			}else if(self.ussd_internet_page()==self.pageState.ussd_internet_uncapped){
				var termsValue = $("#termsChk3").attr("checked")==undefined?false:true;
				if(!termsValue){
					$("#errorDiv3").show();
					return;
				}
				var operation = getUncappedOperation(getBillingPreference("uncappedChoose"));
				self.USSDcommand(operation);
				self.sendToNet();
			}else if(self.ussd_internet_page()==self.pageState.ussd_internet_notsure){
				var operation = getNotSureOperation(getBillingPreference("billingPreferenceVolume"));
				self.USSDcommand(operation);
				self.sendToNet();
			}
		};
		
		function getBillingPreference(eleName){
			var ele=$("[name='"+eleName+"']");
			for(var i=0;i<ele.length;i++){
				if(ele[i].checked){
					return ele[i].value;
				}
			}
		}
		
		function getVolumeOperation(preference,prefer){
			if(prefer=="0"){
				if(preference=="0"){
					return "*141*6*2*10#";
				}else if(preference=="1"){
					return "*141*6*2*75#";
				}else if(preference=="2"){
					return "*141*6*2*300#";
				}else if(preference=="3"){
					return "*141*6*2*500#";
				}else if(preference=="4"){
					return "*141*6*2*1#";
				}else if(preference=="5"){
					return "*141*6*2*2#";
				}
			}else if(prefer=="1"){
				if(preference=="0"){
					return "*141*6*10#";
				}else if(preference=="1"){
					return "*141*6*75#";
				}else if(preference=="2"){
					return "*141*6*300#";
				}else if(preference=="3"){
					return "*141*6*500#";
				}else if(preference=="4"){
					return "*141*6*1#";
				}else if(preference=="5"){
					return "*141*6*2#";
				}
			}
		}
		
		function getDurationOperation(prefer){
			if(prefer=="0"){
				return "*141*6*3*2#";
			}else if(prefer=="1"){
				return "*141*6*3*1#";
			}
		}
		
		function getUncappedOperation(prefer){
			if(prefer=="0"){
				return "*141*6*4*2#";
			}else if(prefer=="1"){
				return "*141*6*4*1#";
			}
		}
		
		function getNotSureOperation(prefer){
			if(prefer=="10"){
				return "*141*6*2*10#";
			}else if(prefer=="75"){
				return "*141*6*2*75#";
			}else if(prefer=="300"){
				return "*141*6*2*300#";
			}else if(prefer=="500"){
				return "*141*6*2*500#";
			}else if(prefer=="1"){
				return "*141*6*2*1#";
			}else if(prefer=="2"){
				return "*141*6*2*2#";
			}
		}
		
		self.clickLow = function(){
			changeToState(self.purchaseState.low);
		};
		
		self.clickMedium = function(){
			changeToState(self.purchaseState.medium);
		};
		
		self.clickHigh = function(){
			changeToState(self.purchaseState.high);
		};
		
		function changeToState(currentState){
			self.currentState(currentState);
			if(currentState==0){
				$("#purchase_first").addClass("first_on");
				$("#purchase_second").removeClass("second_on");
				$("#purchase_third").removeClass("three_on");
			}else if(currentState==1){
				$("#purchase_first").removeClass("first_on");
				$("#purchase_second").addClass("second_on");
				$("#purchase_third").removeClass("three_on");
			}else if(currentState==2){
				$("#purchase_first").removeClass("first_on");
				$("#purchase_second").removeClass("second_on");
				$("#purchase_third").addClass("three_on");
			}
		}		
		
		self.purchaseLow = function(){
			var termsValue = $("#termsChk4").attr("checked")==undefined?false:true;
			if(!termsValue){
				$("#errorDiv4").show();
				return;
			}
			var notSureSelect = $("[name='notSureChoose']:checked").val();
			if(notSureSelect=="0"){
				if(self.currentState()==self.purchaseState.low){
					self.USSDcommand("*141*6*2*10#");
				}else if(self.currentState()==self.purchaseState.medium){
					self.USSDcommand("*141*6*2*300#");
				}else if(self.currentState()==self.purchaseState.high){
					self.USSDcommand("*141*6*2*1#");
				}
			}else if(notSureSelect=="1"){
				if(self.currentState()==self.purchaseState.low){
					self.USSDcommand("*141*6*10#");
				}else if(self.currentState()==self.purchaseState.medium){
					self.USSDcommand("*141*6*300#");
				}else if(self.currentState()==self.purchaseState.high){
					self.USSDcommand("*141*6*1#");
				}
			}
			
			self.sendToNet();
		};
		
		self.purchaseHigh = function(){
			var termsValue = $("#termsChk4").attr("checked")==undefined?false:true;
			if(!termsValue){
				$("#errorDiv4").show();
				return;
			}
			var notSureSelect = $("[name='notSureChoose']:checked").val();
			if(notSureSelect=="0"){
				if(self.currentState()==self.purchaseState.low){
					self.USSDcommand("*141*6*2*75#");
				}else if(self.currentState()==self.purchaseState.medium){
					self.USSDcommand("*141*6*2*500#");
				}else if(self.currentState()==self.purchaseState.high){
					self.USSDcommand("*141*6*2*2#");
				}
			}else if(notSureSelect=="1"){
				if(self.currentState()==self.purchaseState.low){
					self.USSDcommand("*141*6*75#");
				}else if(self.currentState()==self.purchaseState.medium){
					self.USSDcommand("*141*6*500#");
				}else if(self.currentState()==self.purchaseState.high){
					self.USSDcommand("*141*6*2#");
				}
			}
			
			self.sendToNet();
		};
		
		checkTermsCondition1 = function(){
			var termsValue = $("#termsChk1").attr("checked")==undefined?false:true;
			if(termsValue){
				$("#errorDiv1").hide();
			}
			return true;
		};
		
		checkTermsCondition2 = function(){
			var termsValue = $("#termsChk2").attr("checked")==undefined?false:true;
			if(termsValue){
				$("#errorDiv2").hide();
			}
			return true;
		};
		
		checkTermsCondition3 = function(){
			var termsValue = $("#termsChk3").attr("checked")==undefined?false:true;
			if(termsValue){
				$("#errorDiv3").hide();
			}
			return true;
		};
		
		checkTermsCondition4 = function(){
			var termsValue = $("#termsChk4").attr("checked")==undefined?false:true;
			if(termsValue){
				$("#errorDiv4").hide();
			}
			return true;
		};
		
		self.showInfo = function(){
			showTermsAlert("terms_conditions_notes");
		};
		
	}
	
    /**
     * 初始化
     * @method init
     */
	function init() {
		var container = $('#container')[0];
		ko.cleanNode(container);
		var vm = new USSDInformationViewModel();
		ko.applyBindings(vm, container);
		
	}	
	
	return {
		init : init
	};
});