﻿/**
 * setting--device seeting--USSD module
 * 
 * @module ussd
 * @class ussd
 */
define([ 'jquery', 'service', 'knockout'], function($, service, ko) {
	
    /**
     * @class USSDInformationViewModel
     * @constructor
     */
	function USSDInformationViewModel() {
		var self = this;
		self.billedMethod = ko.observable();
		
		self.conditions = ko.observable("<a href='#' style='color:#0000ff;text-decoration:underline;'>Terms and Conditions</a>");
		
		/**
		 * 发送USSD命令
		 * @method sendToNet
		 */
		self.sendToNet = function(){
			var termsValue = $("#termsChk").attr("checked")==undefined?false:true;
			if(!termsValue){
				$("#errorDiv").show();
				return;
			}
			showLoading();
			
			var params = {};
                params.operator = "ussd_send";
                params.strUSSDCommand = getCommand();
				params.sendOrReply = "send";
			
			service.getUSSDResponse(params, function(result, content){
				hideLoading();
				if(result){
					showAlert(decodeMessage(content.data, true));
				}else{
					showAlert(content);
				}
			});
		};
		
		function getCommand(){
			var SMSType = $("[name='billingMethod']:checked").val();
			if(SMSType=="0"){
				return "*141*6*5*1*1#";
			}else if(SMSType=="1"){
				return "*141*6*5*1#";
			}
			return "";
		}
		
		function initBilledMethod(){
			showLoading();
			var params = {};
                params.operator = "ussd_send";
                params.strUSSDCommand = "*141*6*5*2*1#";
				params.sendOrReply = "send";
			
			service.getUSSDResponse(params, function(result, content){
				hideLoading();
				if(result){
					self.billedMethod(decodeMessage(content.data, true));
				}else{
					self.billedMethod("unknown");
				}
				
			});
		}
		
		checkTermsCondition = function(){
			var termsValue = $("#termsChk").attr("checked")==undefined?false:true;
			if(termsValue){
				$("#errorDiv").hide();
			}
			return true;
		};
		
		self.showInfo = function(){
			showTermsAlert("terms_conditions_notes");
		};
		
		initBilledMethod();
	}
	
    /**
     * 初始化
     * @method init
     */
	function init() {
		var container = $('#container')[0];
		ko.cleanNode(container);
		var vm = new USSDInformationViewModel();
		ko.applyBindings(vm, container);
		
	}	
	
	return {
		init : init
	};
});