/**
 * @module url filter setting
 * @class url filter
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore' ],

function($, ko, config, service, _) {

    /**
     * system url filter setting VM
     * @class UrlFilterSettingVM
     */
	function UrlFilterSettingVM() {
        var self = this;
        var info = service.getUrlFilterList();
        var info_white = service.getUrlFilterWhiteList();
        var flag = getUrlFlag();
		var columnsTmpl = [
			{ columnType:"checkbox", rowText:"index", width:"30%"},
			{ headerTextTrans:"URL_addr", rowText:"url", width:"70%"}
		];

		self.rules = ko.observableArray(info.urlFilterRules);
        self.rulesWhite =  ko.observableArray(info_white.urlFilterRules);
		self.urlType = ko.observable(flag.urlFlag);
        if(self.urlType() == '2'){
            self.isShowAdd = ko.observable(false);
            self.isShowBlack = ko.observable(false);
         }else {
            self.isShowAdd = ko.observable(true);
            self.isShowBlack = ko.observable(true);
            if(self.urlType() == '0'){
                $("#isShowBlackTitle").show();
                $("#isShowWhiteTitle").hide();

            }else if(self.urlType() == '1'){
                $("#isShowBlackTitle").hide();
                $("#isShowWhiteTitle").show();
            }
        }

        if(self.urlType() == '0'){
            self.gridTemplate = new ko.simpleGrid.viewModel({
                data:self.rules(),
                idName:"index",
                columns:columnsTmpl,
                tmplType:'list',
                pageSize: 10
            });
        }else if(self.urlType() == '1'){
            self.gridTemplate = new ko.simpleGrid.viewModel({
                data: self.rulesWhite(),
                idName:"index",
                columns:columnsTmpl,
                tmplType:'list',
                pageSize: 10
            });
        }else{
            self.gridTemplate = new ko.simpleGrid.viewModel({
                data: self.rulesWhite(),
                idName:"index",
                columns:columnsTmpl,
                tmplType:'list',
                pageSize: 10
            });
        }
		self.clear = function() {
            $("#addURLFilter").val("");
        };
		/*
			������ɾ��ص�����
			@method callback
		*/
		
		self.callback = function(data){
			if(data.result == "success") {
				self.clear();
				init(self);
				successOverlay();
				$("#urlFilters").translate();
			} else {
				errorOverlay();
			}
		}

        self.addRule = function() {
            if(self.urlType()== '0'){
                if(self.rules().length >= config.urlFilterMax) {
                    showAlert({msg: "url_filter_max", params: config.urlFilterMax});
                    return false;
                }
                var tempArray = [];
                for(var i = 0; i < self.rules().length; i++) {
                    tempArray.push(self.rules()[i].url);
                }
                if($.inArray($("#addURLFilter").val(), tempArray) != -1) {
                    showAlert("url_repeated");
                    return false;
                }

                showLoading();
                var params = {
                    goformId : "URL_BLACK_FILTER_ADD",
                    addURLFilter : $("#addURLFilter").val()
                };
                service.addUrlFilterRule(params, self.callback);
            }else if(self.urlType() == '1'){
                if(self.rulesWhite().length >= config.urlFilterMax) {
                    showAlert({msg: "url_filter_max", params: config.urlFilterMax});
                    return false;
                }
                var tempArray = [];
                for(var i = 0; i < self.rulesWhite().length; i++) {
                    tempArray.push(self.rulesWhite()[i].url);
                }
                if($.inArray($("#addURLFilter").val(), tempArray) != -1) {
                    showAlert("url_repeated");
                    return false;
                }

                showLoading();
                var params = {
                    goformId : "URL_WHITE_FILTER_ADD",
                    addURLWhiteFilter : $("#addURLFilter").val()
                };
                service.addUrlFilterRule(params, self.callback);
            }

        };
		
		self.deleteRule = function(){

            showConfirm("confirm_data_delete", function () {
                showLoading();
                var params = {};
                if(self.urlType() == '0'){
                    params.goformId = "URL_BLACK_FILTER_DELETE";
                    params.url_filter_delete_id = self.gridTemplate.selectedIds().join(";") + ";";
                }else if(self.urlType() == '1'){
                    params.goformId = "URL_WHITE_FILTER_DELETE";
                    params.url_white_filter_delete_id = self.gridTemplate.selectedIds().join(";") + ";";
                }
                service.deleteSelectedRules(params, self.callback);
            });
		}

        self.settingUrl = function(){
            showLoading();
            var params = {};
            params.url_filter_mode = self.urlType();
            service.setUrlFilterFlag(params,self.callback);
        }
    }
    /**
     * 获取信息
     * @method getPortFilter
     */
    function getUrlFlag() {
        return service.getUrlFilterFlag();
    }

    /**
     * ��ʼ�� UrlFilterSettingVM model
     * @method init
     */
	function init() {
		var container = $('#container');
		ko.cleanNode(container[0]);
		var vm = new UrlFilterSettingVM();
        var flag = getUrlFlag();
        vm.urlType (flag.urlFlag);
		ko.applyBindings(vm, container[0]);
        $('#urlFilterForm').validate({
            submitHandler : function() {
                vm.addRule();
            },
            rules: {
                addURLFilter: 'url_filter_check'
            }
        });
		
		$("#urlFilterListForm").validate({
			submitHandler : function(){
				vm.deleteRule();
			}
		});

        $("#urlSettingsForm").validate({
            submitHandler : function(){
                vm.settingUrl();
            }
        });
	}

	return {
		init : init
	};
});