define(['service', 'jquery', 'status_check'], function(service, $, status) {
    var $adjustByTime;
    var $adjustByData;
    var $frmAdjust;
    var packageType;
    var $timeAdjust;
    var $dataAdjust;
    var $dataUnit;
	var $usedTimeUnit;
	
    function initData() {
        var info = service.getTrafficAlertInfo();
        packageType = info.dataLimitTypeChecked;
        if(packageType == "1") {
            var usedData = transUnit(parseInt(info.monthlySent, 10) + parseInt(info.monthlyReceived, 10), false);
            var dataInfo = getDataInfo(usedData);
            $dataAdjust.val(dataInfo.data);
            $dataUnit.val(getUnitValue(dataInfo.unit));
            $adjustByData.show();
        } else {
			var timeInfo = transSecond2Time(info.monthlyConnectedTime);
			$usedTimeUnit.val(getUnitByTime(timeInfo));
            $timeAdjust.val(getUsedTimeByUnit($usedTimeUnit.val() , timeInfo));
            $adjustByTime.show();
        }
    }

    function getDataInfo(value) {
        return {
            data: /\d+(.\d+)?/.exec(value)[0],
            unit: /[A-Z]{1,2}/.exec(value)[0]
        }
    }

    function getUnitValue(unit) {
        unit = unit.toUpperCase();
        if (unit == 'GB') {
            return '1024';
        } else if (unit == 'TB') {
            return '1048576';
        } else {
            return '1';
        }
    }
	
	function getUnitByTime(monthlyConnectedTime){
		if(getTimeHours(monthlyConnectedTime).m != 0){
		   return "1";
		}
		else{
		   return "60";
		}
	}
	
	function getTimeHours(monthlyConnectedTime){
		var t = monthlyConnectedTime.split(':');
            return {
                h: parseInt(t[0], 10),
                m: parseInt(t[1], 10),
                s: parseInt(t[2], 10)
            }
	}
	
	function getUsedTimeByUnit(val,monthlyConnectedTime){
		if(val=="60"){
			   return getTimeHours(monthlyConnectedTime).h;
			}
			else{
			   return getTimeHours(monthlyConnectedTime).h*60+getTimeHours(monthlyConnectedTime).m;
			}
	}

    function init() {
        $adjustByTime = $('#adjustByTime');
        $adjustByData = $('#adjustByData');
        $frmAdjust = $('#frmAdjust');
        $timeAdjust = $('#timeAdjust');
        $dataAdjust = $('#dataAdjust');
        $dataUnit = $('#dataUnit');
		$usedTimeUnit = $('#usedTimeUnit');

        initData();

        $('#adjustSave').off('click').on('click', function() {
            $frmAdjust.submit();
        });

        $frmAdjust.validate({
            submitHandler : function() {
                adjustSave();
            },
            rules : {
                timeAdjust : {
                    range_data_usage : [ 0, 10000 ],
					point_data_usage : true
                },
                dataAdjust : {
                    range_data_usage : [ 0, 10000 ],
					point_data_usage : true
                }
            }
        });
    }

    function adjustSave() {
        showLoading();
        service.trafficCalibration({
            way: packageType,
            timeAdjust: Math.round($timeAdjust.val()*$usedTimeUnit.val()*60),
            dataAdjust: Math.round($dataAdjust.val() * $dataUnit.val()*1024*1024)
        }, function(data){
            if(data.result == 'success'){
                status.setTrafficAlertPopuped(false);
                successOverlay();
            } else {
                errorOverlay();
            }
        }, function(data){
            errorOverlay();
        })
    }
	$.validator.addMethod("range_data_usage", function (value, element, param) {
		if(value.substring(value.length-1) == '.' || value.substring(0,1) == '.' || ( value.substring(0,1) == '0' && value.length != 1 && value.split('.').length == 1) ){
			return false;
		} else {
			return this.optional(element) || ( value >= param[0] && value <= param[1] );
		}
    });
	
	$.validator.addMethod("point_data_usage", function (value, element, param) {
		if(value.split('.')[1] && value.split('.')[1].length > 2){
			return false;
		} else {
			return true;
		}
    });

    return {
        init: init
    }
});
