﻿/**
 * setting--device seeting--USSD module
 * 
 * @module ussd
 * @class ussd
 */
define([ 'jquery', 'service', 'knockout'], function($, service, ko) {
	
    /**
     * @class USSDInformationViewModel
     * @constructor
     */
	function USSDInformationViewModel() {
		var self = this;
		
		self.conditions = ko.observable("<a href='#' style='color:#0000ff;text-decoration:underline;'>Terms and Conditions</a>");
		
		/**
		 * 发送USSD命令
		 * @method sendToNet
		 */
		self.sendToNet = function(){			
			var termsValue = $("#termsChk").attr("checked")==undefined?false:true;
			if(!termsValue){
				$("#errorDiv").show();
				return;
			}
			showLoading();
			
			var params = {};
                params.operator = "ussd_send";
                params.strUSSDCommand = getSelectedData();
				params.sendOrReply = "send";
			
			service.getUSSDResponse(params, function(result, content){
				hideLoading();
				if(result){
					showAlert(decodeMessage(content.data, true));
				}else{
					showAlert(content);
				}
			});
		};
		
		checkTermsCondition = function(){		
			var termsValue = $("#termsChk").attr("checked")==undefined?false:true;
			if(termsValue){
				$("#errorDiv").hide();
			}
			return true;			
		};
		
		self.showInfo = function(){
			showTermsAlert("terms_conditions_notes");
		};		
	}

	
	
	function getSelectedData(){
		var seletedSMS=$("[name='ussd_purchase_sms']");
		for(var i=0;i<seletedSMS.length;i++){
			if(seletedSMS[i].checked){
				return getCommand(seletedSMS[i].value);
			}
		}
	}
	
	function getCommand(SMSType){
		if(SMSType=="50"){
			return "*141*7*50#";
		}else if(SMSType=="100"){
			return "*141*7*100#";
		}else if(SMSType=="200"){
			return "*141*7*200#";
		}else if(SMSType=="500"){
			return "*141*7*500#";
		}else if(SMSType=="2000"){
			return "*141*7*2000#";
		}
		return "";
	}
	
    /**
     * 初始化
     * @method init
     */
	function init() {
		var container = $('#container')[0];
		ko.cleanNode(container);
		var vm = new USSDInformationViewModel();
		ko.applyBindings(vm, container);
		
	}	
	
	return {
		init : init
	};
});