﻿/**
 * setting--device seeting--USSD module
 * 
 * @module ussd
 * @class ussd
 */
define([ 'jquery', 'service', 'knockout'], function($, service, ko) {
	
	var initUSSD=true;
	var timeOutFlag=0;//计时
	var reply_flag=false;//是否已经得到回复
	var USSDLocation = {SEND:0, REPLY:1};
	var callbackTemp;
	var ussd_action=1;//初始化为成功获得返回消息
	var interval=0;

    /**
     * @class USSDInformationViewModel
     * @constructor
     */
	function USSDInformationViewModel() {
		var self = this;
		
        self.checkBalances=ko.observable("*141#");
        self.detailedBalances=ko.observable("*141*1#");
        self.purchaseBalances=ko.observable("*141*2#");
		self.USSDSend=ko.observable("");
		$("#ussdCommand").focus();
		
		/**
		 * 发送USSD命令
		 * @method sendToNet
		 */
		self.sendToNet = function(){
			
			showLoading();	
			
			var params = {};
                params.operator = "ussd_send";
                params.strUSSDCommand = self.USSDSend();
				params.sendOrReply = "send";
			
			service.getUSSDResponse(params, function(result, content){
				hideLoading();
                $("#ussdCommand").val("");
				if(result){
						$("#USSD_Content").val(decodeMessage(content.data, true));
				}else{
					showAlert(content);
				}
			});
		};
		

			
			
			
		
		
		
		
		
	}

    /**
     * 初始化
     * @method init
     */
	function init() {
		var container = $('#container')[0];
		ko.cleanNode(container);
		var vm = new USSDInformationViewModel();
		ko.applyBindings(vm, container);	
        $("#ussdCommand").focus();
		
	}	
	
	return {
		init : init
	};
});