﻿/**
 * setting--device seeting--USSD module
 * 
 * @module ussd
 * @class ussd
 */
define([ 'jquery', 'service', 'knockout'], function($, service, ko) {
	
    /**
     * @class USSDInformationViewModel
     * @constructor
     */
	function USSDInformationViewModel() {		
		var self = this;
		
		$("#USSD_Content").val($.i18n.prop("ussd_banlance_note"));
		
		/**
		 * 发送USSD命令
		 * @method sendToNet
		 */
		self.sendToNet = function(){
			showLoading();	
			
			var params = {};
                params.operator = "ussd_send";
                params.strUSSDCommand = "*141*1*3#";
				params.sendOrReply = "send";
			
			service.getUSSDResponse(params, function(result, content){
				hideLoading();				
				if(result){
					$("#USSD_Content").val(decodeMessage(content.data, true));
				}else{
					showAlert(content);
				}
			});
		};
		
		/**
		 * 跳转到purchase
		 * @method gotoPurchase
		 */
		self.gotoPurchase = function(){
			window.location.hash="#ussd_purchase_internet";
		};
	}

    /**
     * 初始化
     * @method init
     */
	function init() {
		var container = $('#container')[0];
		ko.cleanNode(container);
		var vm = new USSDInformationViewModel();
		ko.applyBindings(vm, container);	
		
	}	
	
	return {
		init : init
	};
});