﻿/**
 * setting--device seeting--USSD module
 * 
 * @module ussd
 * @class ussd
 */
define([ 'jquery', 'service', 'knockout'], function($, service, ko) {
	
    /**
     * @class USSDMyNumberModel
     * @constructor
     */
	function USSDMyNumberModel() {
        var self = this;
        
        self.myNumber = ko.observable("");
        
        /**
		 * 发送USSD命令
		 * @method sendToNet
		 */
		self.sendToNet = function(){
			showLoading();	
			
			var params = {};
                params.operator = "ussd_send";
                params.strUSSDCommand = "*131*3#";
				params.sendOrReply = "send";
			
			service.getUSSDResponse(params, function(result, content){
				hideLoading();
                /*result = true;
                content = {};
                content.data = "00590065006C006C006F002100200059006F007500720020004D0053004900530044004E002000690073002000320037003700380030003300390032003300380034";*/		
				if(result){
					self.myNumber(decodeMessage(content.data, true));
				}else{
					showAlert(content);
				}
			});
		};		
	}
	
    /**
     * 初始化
     * @method init
     */
	function init() {
		var container = $('#container')[0];
		ko.cleanNode(container);
		var vm = new USSDMyNumberModel();
		ko.applyBindings(vm, container);
        
        vm.sendToNet();
		
	}	
	
	return {
		init : init
	};
});