#!/bin/sh
# ===========================================================
# usage: IP pasathrough
# just for  publicIP pasathrough

ip_passthrough_switch=`cfg get ip_passthrough_enabled`
if [ "1" != "$ip_passthrough_switch" ]
then
    echo "$0:IP Passthrough disabled"
    exit
fi

wan_connected_status=`cfg get ppp_status`
if [ "ppp_disconnected" == "$wan_connected_status" ]
then
    echo "$0: wan not connected"
    exit
fi

wan_ipaddr=`cfg get wan_ipaddr`
wan_ipaddr_passthoughed=`cfg get wan_ipaddr_passthoughed`

if [ "" == "$wan_ipaddr" ]
then
    echo "$0: wan ip is null"
    exit
fi

if [ "$wan_ipaddr" == "$wan_ipaddr_passthoughed" ]
then
    echo "$0:IP Passthrough already actived same public ip."
    exit
fi

wan_netmask=`cfg get wan_netmask`
wan_gateway=`cfg get wan_gateway`
wan_interface=`cfg get wan_v4_dev_name`

cfg set wan_ipaddr_passthoughed=$wan_ipaddr
cfg set wan_interface_passthoughed=$wan_interface

usb_type=`cat /sys/class/android_usb/android0/zte_usb_rndis_ecm_net`
if [ "1" == "$usb_type" ]
then
    echo the devicetype is usb
    usb_device_name="usb0"
elif [ "2" == "$usb_type" -o "4" == "$usb_type" ]
then
    echo the devicetype is usb
    usb_device_name="ecm0"
elif [ "3" == "$usb_type" ]
then
    echo the devicetype is not support
    usb_device_name="rndis0"
else
    echo the devicetype is not support
fi

if [ "0" == "$wan_netmask" -o "" == "$wan_netmask" ]
then
    echo can not get wan_netmask and exit
    exit
fi    
    
#delete publicip conntrack
echo "$0:Deleting client echo Deleting Client Conntrack IP:$wan_ipaddr" > /dev/kmsg
conntrack -D --orig-src $wan_ipaddr
conntrack -D --reply-src $wan_ipaddr
rmnet_def_route=`ip route show | grep default | grep $wan_interface`

#Assign a link local ip to WWAN Interface iface
rmnet_reserved_ip="169.254.3.2"
ifconfig $wan_interface $rmnet_reserved_ip netmask 255.255.255.255 up

#del all unused ip, add WWAN Interface gw ip to bridge0
lan_ipaddr_curr=`cfg get lan_ipaddr_for_current`
bridge0_ip_list=`ip addr | grep "scope global bridge0" | awk '{print $2}' | grep -v $lan_ipaddr_curr`

echo "$bridge0_ip_list" | while read line
do
  #echo "$line"
  if [ "" != "$line" ]; then
    echo "ip addr del $line dev bridge0"
    ip addr del $line dev bridge0
  fi
done

ip addr add $wan_gateway/32 dev bridge0

#add wan ipv4 interface as the default route
ip route add default dev $wan_interface
ip route add $wan_ipaddr dev bridge0

#Marking DHCP packets so that only dhcp packets can be handled by bridge
#creating custom routing table 'ippastbl' for dhcp request handle    
local_route=`ip route show table local | grep local | grep $wan_gateway`
echo local_route=$local_route
iptables -A PREROUTING -i bridge0 -t nat -p udp --dport 67 -j MARK --set-mark 1
echo 200 ippastbl >> /etc/iproute2/rt_tables
ip route del $local_route table local
ip rule add fwmark 1 table ippastbl
ip route add $local_route table ippastbl
#Add SNAT entry
iptables -t nat -I POSTROUTING -o $wan_interface -j SNAT --to $wan_ipaddr

#reset dnsmasq conf
killall -SIGTERM dnsmasq

Local_domain=`cfg get LocalDomain`
lan_ipaddr=`cfg get lan_ipaddr_for_current`
dnsmasq_publicip_conf="/tmp/dnsmasq-publicip.conf"
i_leasetime=`cfg get dhcpLease_hour`
dnsmasaq_publicip_lease="/tmp/dnsmasq-publicip.leases"
echo address=/$Local_domain/$lan_ipaddr > $dnsmasq_publicip_conf
echo address=/$Local_domain/fe80::91 >> $dnsmasq_publicip_conf
echo dhcp-option=6,$lan_ipaddr >> $dnsmasq_publicip_conf
echo dhcp-range=$wan_ipaddr,$wan_ipaddr,$wan_netmask,$i_leasetime"h" >> $dnsmasq_publicip_conf
echo dhcp-leasefile=$dnsmasaq_publicip_lease >> $dnsmasq_publicip_conf

dnsmasq -c 300 -C $dnsmasq_publicip_conf
sleep 1

echo "$0: disable usb" > /dev/kmsg   
echo 0 > /sys/class/android_usb/android0/enable
ifconfig $usb_device_name down
sleep 1
echo "$0: enable usb" > /dev/kmsg   
echo 1 > /sys/class/android_usb/android0/enable
ifconfig $usb_device_name up

iptables -t filter -A FORWARD -s $wan_ipaddr -j ACCEPT
iptables -t filter -A FORWARD -o $wan_interface -j DROP

sleep 2
ip route add default dev $wan_interface
sleep 2
ip route add default dev $wan_interface
sleep 2
ip route add default dev $wan_interface

echo "$0:IP Passthrough Activated" > /dev/kmsg    