#/bin/sh
#filename: static_ip_init.sh
#author: created by guoshoupeng 2016-02-17
#nv itme format: mac_ip_list:mac_addr+ip_addr;mac_addr+ip_addr;
#
DNSMASQ_CONF="/usr/zte/zte_conf/config/dnsmasq.conf"
DNSMASQ_CONF_TMP="/usr/zte/zte_conf/config/dnsmasq.conf.tmp"

product_type=`cfg get product_type`

mac_ip_list=`cfg get mac_ip_list`
mac_ip_status=`cfg get mac_ip_status`

mang_num=`echo $mac_ip_list| grep -c ";"`
one_num=`echo $mac_ip_list| grep -c "+"`
#echo "mang_num : [$mang_num] one_num: [$one_num]" 

init_dnsmasq_conf_file()
{
	sed '/dhcp-host/d' $DNSMASQ_CONF > $DNSMASQ_CONF_TMP
	cat $DNSMASQ_CONF_TMP > $DNSMASQ_CONF
	rm -rf $DNSMASQ_CONF_TMP
}


modify_dnsmasq_conf_file()
{
	if [ "$mang_num" -eq "0" ]; then
		if [ "$one_num" -eq "1" ]; then
			mac_addr=`echo $mac_ip_list| awk -F '+' '{print $1}'`
			ip_addr=`echo $mac_ip_list| awk -F '+' '{print $2}'`
			echo "dhcp-host=$mac_addr,$ip_addr" >> $DNSMASQ_CONF
		else
			echo "the mac_ip_list is null"
		fi		
	else
		var=`echo $mac_ip_list |awk -F ';' '{print $0}' | sed "s/;/ /g"`
		#echo "var : [$var]"
		for list in $var
		do
			mac_addr=`echo $list| awk -F '+' '{print $1}'`
			ip_addr=`echo $list| awk -F '+' '{print $2}'`
			echo "dhcp-host=$mac_addr,$ip_addr" >> $DNSMASQ_CONF
		done
	fi
}


#added by guoshoupeng for mac_ip_bind 2016.02.17 == begin
if [ "$1" == "init" ]; then
	echo "mac_ip_bind function init no need kill dnsmasq"
else
	killall -9 dnsmasq
fi

init_dnsmasq_conf_file

if [ "$mac_ip_status" == "1" ]; then
	modify_dnsmasq_conf_file
else
	echo "mac_ip_bind function is disabled"
fi

if [ "$1" == "init" ]; then
	echo "mac_ip_bind function init no need restart dnsmasq"
else
	if [ "$product_type" == "UNI_CORE_CPE" ]; then
		dnsmasq -c 300 -C $DNSMASQ_CONF -z
	else
		dnsmasq -c 300 -C $DNSMASQ_CONF
	fi
fi


#added by guoshoupeng for mac_ip_bind 2017.02.17 == end
