#!/bin/sh
# ===========================================================
# usage: IP pasathrough
# just for  publicIP pasathrough

bridge0_ip_count=`ip addr | grep -c "scope global bridge0"`
if [ "1" == "$bridge0_ip_count" ]; then
    echo "$0:IP Passthrough not actived, no extra ip on bridge0"
    exit
fi

#del all extra ip addr on bridge0
lan_ipaddr_curr=`cfg get lan_ipaddr_for_current`
bridge0_ip_list=`ip addr | grep "scope global bridge0" | awk '{print $2}' | grep -v $lan_ipaddr_curr`

echo "$bridge0_ip_list" | while read line
do
  #echo "$line"
  if [ "" != "$line" ]; then
    echo "ip addr del $line dev bridge0"
    ip addr del $line dev bridge0
  fi
done

wan_ipaddr_passthoughed=`cfg get wan_ipaddr_passthoughed`
wan_interfcace_passthoughed=`cfg get wan_interface_passthoughed`
ip route delete $wan_ipaddr_passthoughed dev bridge0
iptables -t nat -D POSTROUTING -o $wan_interfcace_passthoughed  -j SNAT --to $wan_ipaddr_passthoughed

cfg set wan_ipaddr_passthoughed=""
cfg set wan_interface_passthoughed=""

iptables -D PREROUTING -i bridge0 -t nat -p udp --dport 67 -j MARK --set-mark 1
ip rule del fwmark 1 table ippastbl
ip route flush table ippastbl
sed -i '/200 ippastbl/d' /etc/iproute2/rt_tables

wan_interface=`cfg get wan_v4_dev_name`
wan_ipaddr=`cfg get wan_ipaddr`
wan_netmask=`cfg get wan_netmask`
wan_gateway=`cfg get wan_gateway`
wan_connected_status=`cfg get ppp_status` 
if [ "ppp_disconnected" == "$wan_connected_status" ]; then
    echo wwan is not connected
else
    ifconfig $wan_interface $wan_ipaddr netmask $wan_netmask up
    ip route add default via $wan_gateway dev $wan_interface
fi

usb_type=`cat /sys/class/android_usb/android0/zte_usb_rndis_ecm_net`
if [ "1" == "$usb_type" ]
then
    echo the devicetype is usb
    usb_device_name="usb0"
elif [ "2" == "$usb_type" -o "4" == "$usb_type" ]
then
    echo the devicetype is usb
    usb_device_name="ecm0"
elif [ "3" == "$usb_type" ]
then
    echo the devicetype is not support
    usb_device_name="rndis0"
else
    echo the devicetype is not support
fi

killall -SIGTERM dnsmasq
dnsmasq -c 300 -C /usr/zte/zte_conf/config/dnsmasq.conf
echo "$0: disable usb" > /dev/kmsg   
echo 0 > /sys/class/android_usb/android0/enable
ifconfig $usb_device_name down
sleep 1
echo "$0: enable usb" > /dev/kmsg   
echo 1 > /sys/class/android_usb/android0/enable
ifconfig $usb_device_name up

echo "$0:IP Passthrough disabled" > /dev/kmsg    