# 
# Created by zhangyuelong10100551 @ 2014.6.26 
# init firewall
#

#FMT_ECHO=1>/dev/null 2>&1
wan_dev_name=$1
remote_manager=`cfg get RemoteManagement`
wan_ping=`cfg get WANPingFilter`
firewall_switch=`cfg get fwSwitchEnabled`
ZTE_SYS_FW_FILTER_CHAIN=sys_fw_filter

if [ "$wan_dev_name" == "" ]
then
  echo "$0: no dev in, set rmnet_data0!"
  wan_dev_name="rmnet_data0"
fi

#clear chain
iptables -t filter -F $ZTE_SYS_FW_FILTER_CHAIN
ip6tables -t filter -F $ZTE_SYS_FW_FILTER_CHAIN
iptables -D INPUT -p tcp --dport 22 -j DROP
iptables -D INPUT -p udp --dport 22 -j DROP
iptables -D INPUT -p tcp --dport 5555 -j DROP
iptables -D INPUT -p udp --dport 5555 -j DROP

#for lan ssh
iptables -A INPUT -p tcp --dport 22 -j DROP
iptables -A INPUT -p udp --dport 22 -j DROP
iptables -A INPUT -p tcp --dport 5555 -j DROP
iptables -A INPUT -p udp --dport 5555 -j DROP

iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p icmp --icmp-type echo-reply -j ACCEPT
ip6tables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p icmpv6 --icmpv6-type echo-reply -j ACCEPT

if [ "$remote_manager" == "0" ]
then
  iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp --dport 80 -j DROP
  ip6tables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp --dport 80 -j DROP
fi

if [ "$firewall_switch" == "0" ]
then
  wan_ping=1
fi

if [ "$wan_ping" == "0" ]
then
  iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p icmp -j DROP
  ip6tables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p icmpv6 --icmpv6-type echo-request -j DROP
fi

# disable 22:sh
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp --dport 22 -j DROP
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p udp --dport 22 -j DROP
# disable 23: telnet
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp --dport 23 -j DROP
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p udp --dport 23 -j DROP
# disable 53:domain
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp --dport 53 -j DROP
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p udp --dport 53 -j DROP
# disable 1900:upnp
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp --dport 1900 -j DROP
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p udp --dport 1900 -j DROP
# disable 5555:freeciv
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p tcp --dport 5555 -j DROP
iptables -A $ZTE_SYS_FW_FILTER_CHAIN -i $wan_dev_name -p udp --dport 5555 -j DROP
echo "firewall_sys_fw done"



