#!/bin/sh
# ===========================================================
# bridge_setup.sh
# create by zhangyuelong10100551 2012.5.2

# here we check if datacard(nat) mode
product_type=`cfg get product_type`
lan_ipaddr=`cfg get lan_ipaddr_for_current`
lan_netmask=`cfg get lan_netmask`
inte_name=""
cpe_lan_name=`cfg get rj45_if_name`
# only data card mode
if [ "ONLY_DATA_CARD" = "$product_type" ]
then
  echo "bridge_setup.sh: $product_type only data card mode, exit"
  exit
else
  echo "bridge_setup.sh: $product_type will check product type further"
fi


turbo_nat_flag=`cat /sys/class/android_usb/android0/zte_usb_rndis_ecm_net`

if [ "$turbo_nat_flag" == "1" ] ; then
    inte_name="usb0"
elif [ "$turbo_nat_flag" == "2" -o "$turbo_nat_flag" == "4" ] ; then
    inte_name="ecm0"
elif [ "$turbo_nat_flag" == "3" ] ; then
    inte_name="rndis0"
else
   echo "bridge_setup.sh:the interface is not usb0 or ecm0"
fi

rmmod turbo_nat
if [ "$inte_name" == "usb0" ] ; then
    insmod /lib/modules/3.4.0+/kernel/net/turbonat/turbo_nat.ko
fi




# datacard(nat), just setup usb0
if [ "NO_DRIVER_DATA_CARD" = "$product_type" -o "DRIVER_DATA_CARD" = "$product_type" ]
then
  ifconfig bridge0 down
  brctl delbr bridge0
  echo "bridge_setup.sh: $product_type host(less) datacard, just setup $inte_name"
  usb_ipaddr=`cfg get lan_ipaddr_for_current`
  if [ "$inte_name" != "" ] ; then
    ifconfig "$inte_name" $usb_ipaddr netmask $lan_netmask up
  fi
  if [ "$inte_name" == "usb0" -o "$inte_name" == "" -o "$inte_name" == "rndis0" -o "$inte_name" == "ecm0"  ] ; then
    exit
  fi
 else
  echo "bridge_setup.sh: need set bridge0, just go"
fi


# here we setup bridge0

 echo  "bridge_setup.sh: begin to set bridge********"
if [ -d "/sys/class/net/bridge0" ] ;then
  ifconfig bridge0 $lan_ipaddr netmask $lan_netmask up
  echo "bridge_setup.sh: bridge0 exist ..."
else
  echo "bridge_setup.sh: setup bridge0 ..."
  brctl addbr bridge0
  ifconfig bridge0 $lan_ipaddr netmask $lan_netmask up
  echo 1 > /proc/sys/net/ipv4/conf/bridge0/proxy_arp
  iptables -A FORWARD --in-interface bridge0 -j ACCEPT
fi

if [ "$inte_name" != "" ] ; then
    echo "bridge_setup.sh: ifup $inte_name iface  ..."
	ifconfig "$inte_name" 169.254.3.1 netmask 255.255.255.0 up
	route del -net 169.254.3.0 netmask 255.255.255.0 dev "$inte_name"
	ip -6 route del fe80::/64 dev "$inte_name"
	echo "bridge_setup.sh: add $inte_name to bridge ..."
	brctl addif bridge0 "$inte_name"
fi

if [ "UNI_CORE_CPE" = "$product_type" ] ;then
	if [ ! -f "/tmp/eth0_init.txt" ] ;then
		if [ "$cpe_lan_name" != "" ] ; then
			ifconfig "$cpe_lan_name" up
			route del -net 169.254.3.0 netmask 255.255.255.0 dev "$cpe_lan_name"
			ip -6 route del fe80::/64 dev "$cpe_lan_name"
			brctl addif bridge0 "$cpe_lan_name"
			echo "brctl addif bridge0 "$cpe_lan_name""
			touch /tmp/eth0_init.txt
		fi
	fi
fi
#if_sta=`cfg get wifi_sta_net`   
#if_ap=`cfg get wifi_ap_net`     
#if_map=`cfg get wifi_m_ap_net`  
#cur_mod=`cfg get apsta_type`     # ap / apsta / apap
#echo "bridge_setup.sh: cur_mod[$cur_mod], if_ap[$if_ap], if_map[$if_map], if_sta[$if_sta]..."

#if [ "$cur_mod" == "ap" ] || [ "$cur_mod" == "apsta" ]; then
#	brctl delif bridge0 $if_sta
#	brctl delif bridge0 $if_map
#	brctl addif bridge0 $if_ap
#elif [ "$cur_mod" == "apap" ]; then
#	brctl delif bridge0 $if_sta
#	brctl addif bridge0 $if_map
#	brctl addif bridge0 $if_ap
#else
#	echo "###################bridge_setup.sh: unknown apsta_type[$apsta_type]###################"
#fi

echo "bridge_setup.sh: done ..."
# =============================================================
