function service() {
    var wifiCallbackDestination = window;
    var unknownErrorObject = {
        errorType:'deviceError',
        errorId:'123',
        errorText:'UnknownError'
    };
    var isTest = false;
    /**
     * Ajax同步调用
     * @method syncRequest
     * @param {Object} params json参数对象
     * @param {Boolean} isPost 是否为post方法
     */
    function syncRequest(params, isPost) {
        return ajaxRequest(params, null, null, false, isPost);
    }

    /**
     * Ajax异步调用
     * @method asyncRequest
     * @param {Object} params json参数对象
     * @param {Function} successCallback 成功回调函数
     * @param {Function} errorCallback 失败回调函数
     * @param {Boolean} isPost 是否为post方法
     */
    function asyncRequest(params, successCallback, errorCallback, isPost) {
        ajaxRequest(params, successCallback, errorCallback, true, isPost);
    }

    /**
     * Ajax异步调用
     * @method ajaxRequest
     * @param {Object} params json参数对象
     * @param {Function} successCallback 成功回调函数
     * @param {Function} errorCallback 失败回调函数
     * @param {Boolean} async 是否为异步方法
     * @param {Boolean} isPost 是否为post方法
     */
    function ajaxRequest(params, successCallback, errorCallback, async, isPost) {
        var result = null;
        if (params.isTest) {
            result = simulate.simulateRequest(params, successCallback, errorCallback, async, isPost);
            if (async) {
                setTimeout(function () {
                    successCallback(result);
                }, getRandomInt(120) + 50);
                //successCallback(result)
                return;
            } else {
                return result;
            }
        }
        $.ajax({
            type:!!isPost ? "POST" : "GET",
            url:isPost ? "/goform/goform_set_cmd_process" : params.cmd ? "/goform/goform_get_cmd_process"
                : "/goform/goform_set_cmd_process",
            data:params,
            dataType:"json",
            async:!!async,
            cache:false,
            error:function (data) {
                if (async) {
                    errorCallback;
                } else if (data.status == 200) {
                    result = jQuery.parseJSON('(' + data.responseText + ')');
                }
            },
            success:function (data) {
                if (async) {
                    successCallback(data);
                } else {
                    result = data;
                }
            }
        });
        if (!async) {
            return result;
        }
    }

    /**
     * doStuff业务处理函数
     * @method doStuff
     * @param {Object} params json参数对象
     * @param {Object} result 错误对象
     * @param {Function} prepare 数据准备函数
     * @param {Function} dealMethod 结果适配函数
     * @param {Object} errorObject 默认错误对象
     * @param {Boolean} isPost 是否为post方法
     */
    function doStuff(args, result, prepare, dealMethod, errorObject, isPost) {
        var params = args[0], callback = args[1], errorCallback = args[2];
        var objectToReturn;

        if (result && typeof result.errorType === 'string') {
            objectToReturn = $.extend(unknownErrorObject, result);

            if (!callback) {
                // sleep(DelayOnEachCallMillis);
                return objectToReturn;
            }
            doCallback(objectToReturn, callback, errorCallback);
        } else {
            objectToReturn = $.extend({}, result); // Duplicate it.

            var requestParams;
            if (prepare) {
                requestParams = prepare(params, isPost);
            } else {
                requestParams = params;
            }
            if (!callback) {
                if (requestParams && (requestParams.cmd || requestParams.goformId)) {
                    var r = syncRequest(requestParams, isPost);
                    if (dealMethod) {
                        objectToReturn = $.extend({}, dealMethod(r));
                    } else {
                        objectToReturn = r;
                    }
                }
                // sleep(DelayOnEachCallMillis);
                return objectToReturn;
            } else {
                if (requestParams && (requestParams.cmd || requestParams.goformId)) {
                    asyncRequest(requestParams, function (data) {
                        if (dealMethod) {
                            objectToReturn = $.extend({}, dealMethod(data));
                        } else {
                            objectToReturn = $.extend({}, data);
                        }
                        //手动处理callback
                        if (!requestParams.notCallback) {
                            doCallback(objectToReturn, callback, errorCallback);
                        }
                    }, function () {
                        if (errorObject) {
                            objectToReturn = $.extend(unknownErrorObject, errorObject);
                        } else {
                            objectToReturn = $.extend(unknownErrorObject, {
                                errorType:'Unknown'
                            });
                        }
                        doCallback(objectToReturn, callback, errorCallback);
                    }, isPost);
                } else {
                    doCallback(objectToReturn, callback, errorCallback);
                }
            }
        }
        function doCallback(resultToReturn, callback, errorCallback) {
            errorCallback = errorCallback ? errorCallback : callback;
            if (isErrorObject(resultToReturn)) {
                switch (resultToReturn.errorType) {
                    case 'cellularNetworkError':
                    case 'deviceError':
                    case 'wifiConnectionError':
                        wifiCallbackDestination.receivedNonSpecificError(resultToReturn);
                        break;
                    default:
                        errorCallback(resultToReturn);
                }
            } else {
                callback(resultToReturn);
            }
        }
    }

    function isErrorObject(object) {
        return typeof object.errorType === 'string';
    }

    /**
     * 获取登录状态
     * @method getLoginStatus
     * @return {Object} JSON
     * @example
     //返回结果格式
     {
     status = "loggedIn";
     }
     */
    function getLoginStatus() {
        return doStuff(arguments, {}, prepare, deal, null, false);

        function prepare(params, isPost) {
            var requestParams = {};
            requestParams.isTest = isTest;
            requestParams.cmd = "login_status";
            return requestParams;
        }

        function deal(data) {
            if (data && data.login_status) {
                var loginStatus = {};
                //it should be an enum rather than Boolean
                switch (data.login_status) {
                    case "0":
                        loginStatus.status = "loggedIn";
                        break;
                    default:
                        loginStatus.status = "loggedOut";
                        break;
                }
                return loginStatus;
            } else {
                return $.extend(unknownErrorObject, {errorType:"LoginStatusError"});
            }
        }
    }

    /**
     * 获取登录相关信息
     * @method getLoginData
     * @return {Object} JSON
     */
    function getLoginData(){
        return doStuff(arguments, {}, prepare, deal, null, false);

        function prepare(params, isPost) {
            var requestParams = {};
            requestParams.isTest = isTest;
            requestParams.cmd = "modem_main_state,puknumber,pinnumber,admin_Password";
            requestParams.multi_data = 1;
            return requestParams;
        }

        function deal(data) {
            if (data) {
                return data;
            } else {
                return unknownErrorObject;
            }
        }
    }

    /**
     * 登录系统
     * @method login
     * @param {Object} JSON
     * @example
     * //返回结果格式
     *{
     *   password:"123456"
     *}
     * @return {Object} JSON
     */
    function login() {
        return doStuff(arguments, {}, prepare, deal, {errorType:'badPassword'}, true);

        function prepare(params, isPost) {
            var obj = {
                isTest:isTest,
                goformId:"LOGIN",
                password:params.password
            };
            return obj;
        }

        function deal(data) {
            //in doc, notes:If the user is 'already logged in' at the device, it calls back as success.
            if (data && (data.result == "0" || data.result == "4")) {
                return     {result:true};
            } else {
                var loginError = {};
                switch (data.result) {
                    case "1":
                        loginError = {errorType:"Login Fail"};
                        break;
                    case "2":
                        loginError = {errorType:"duplicateUser"};
                        break;
                    case "3":
                        loginError = {errorType:"badPassword"};
                        break;
                    /* case "4":
                     loginError = {errorType : "already logged in"};
                     break; */
                    default :
                        loginError = {errorType:"Login Fail"};
                        break;
                }
                return $.extend(unknownErrorObject, loginError);
            }
        }
    }

    /**
     * 退出系统
     *
     * @method logout
     * @return {Object} JSON
     */
    function logout() {

        return doStuff(arguments, {}, prepare, deal, null, true);

        function prepare(params, isPost) {
            var obj = $.extend({}, params);
            obj.isTest = isTest;
            obj.goformId = "LOGOUT";
            return obj;
        }

        function deal(data) {
            if (data && data.result == "success") {
                return {result:true};
            } else {
                return $.extend(unknownErrorObject, {errorType:"loggedOutError"});
            }
        }
    }

    function getLanguage() {
        return doStuff(arguments, {}, prepare, deal, null, false);

        function prepare(params, isPost) {
            var requestParams = {};
            requestParams.isTest = isTest;
            requestParams.cmd = "Language";
            requestParams.multi_data = 1;
            return requestParams;
        }

        function deal(data) {
            if (data) {
                var result = {};
                result.Language = (data && data.Language) ? data.Language : "en";
                return result;
            } else {
                return unknownErrorObject;
            }
        }
    }

    function setLanguage() {
        return doStuff(arguments, {}, prepare, deal, null, true);

        function prepare(params, isPost) {
            var requestParams = {};
            requestParams.isTest = isTest;
            requestParams.goformId = "SET_WEB_LANGUAGE";
            requestParams.Language = params.Language;
            return requestParams;
        }

        function deal(data) {
            if (data) {
                return data;
            } else {
                return unknownErrorObject;
            }
        }
    }

    function getQuickSettingInfo() {
        var ret;
        $.ajax({
            type:"GET",
            url:"/goform/goform_get_cmd_process",
            data:{
                cmd:"Language,SSID1,AuthMode,WPAPSK1,Key1Str1,WscModeOption,ppp_status,APN_config0,APN_config1,APN_config2,APN_config3,APN_config4,APN_config5,APN_config6,APN_config7,APN_config8,APN_config9,APN_config10,APN_config11,APN_config12,APN_config13,APN_config14,APN_config15,APN_config16,APN_config17,APN_config18,APN_config19,apn_index,action,m_profile_name,modem_main_state,apn_mode,apn_auto_config,Key1Type,EncrypType,HideSSID",
                multi_data:1
            },
            dataType:"json",
            cache:false,
            async:false,
            success:function (data) {
                ret = data;
            }
        });
        return ret;
    }

    function setQuickSettingInfo(SetUpSettings) {
        return doStuff(arguments, {}, prepareSetSetUpSettings, dealSetSetUpSettings, null, true);

        function prepareSetSetUpSettings(params) {
            var requestParams = $.extend({}, params);
            requestParams.goformId = "QUICK_SETUP";
            return requestParams;
        }

        function dealSetSetUpSettings(data) {
            if (data && data.result === "success") {
                return {result:true};
            } else {
                return $.extend(unknownErrorObject, {errorType:"SetSetUpError"});
            }
        }
    }

    function getBasicStatus() {
        return doStuff(arguments, {}, prepare, deal);

        function prepare(Params) {
            var requestParams = {};
            requestParams.cmd = "Language,signalbar,ex_wifi_status,modem_main_state,network_type,battery_pers,battery_charging,battery_vol_percent,SSID1,AuthMode,EncrypType,DefaultKeyID,WPAPSK1,Key1Str1,Key2Str1,Key3Str1,Key4Str1,Key1Type,Key2Type,Key3Type,Key4Type,m_SSID,m_AuthMode,m_EncrypType,m_DefaultKeyID,m_WPAPSK1,m_Key1Str1,m_Key2Str1,m_Key3Str1,m_Key4Str1,m_Key1Type,m_Key2Type,m_Key3Type,m_Key4Type,wa_inner_version";
            requestParams.multi_data = 1;
            return requestParams;

        }

        function deal(data) {
            return data;
        }
    }

    function getSIMCardStatus(){
        return doStuff(arguments, {}, prepare, deal);

        function prepare(Params) {
            var requestParams = {};
            requestParams.cmd = "modem_main_state";
            requestParams.multi_data = 1;
            return requestParams;

        }

        function deal(data) {
            return data;
        }
    }

    return{
        getLoginData:getLoginData,
        logout:logout,
        login:login,
        getLoginStatus:getLoginStatus,
        setLanguage:setLanguage,
        getLanguage:getLanguage,
        getQuickSettingInfo:getQuickSettingInfo,
        setQuickSettingInfo:setQuickSettingInfo,
        getBasicStatus:getBasicStatus,
        getSIMCardStatus:getSIMCardStatus
    }
}

var service = service();