
/**
 * @module sleep_mode
 * @class sleep_mode
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore' ],

    function($, ko, config, service, _) {

        var globalTime = "";
        var sntpYears = [];
        var sntpMonths = [];
        var sntpDates = []
        var sntpHours = [];
        var sntpMinutes = [];
        var bigMonth = [1, 3, 5, 7, 8, 10, 12];
        var smallMonth = [4, 6, 9, 11];
        var weekends = ["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];

        //生成年、月、时、分的数组
        produceArray(2000, 2020, sntpYears);
        produceArray(1, 12, sntpMonths);
        produceArray(0, 23, sntpHours);
        produceArray(0, 59, sntpMinutes);

        function produceArray(start, end, arrName) {
            var item = {};
            for(var i = start; i <= end; i++) {
                item.name = i;
                item.value = i;
                arrName.push(new Option(item.name, item.value));
            }
        }

        /**
         * datemode VM
         * @class DataModeVM
         */
        function DataModeVM() {
            var self = this;
            var data = service.getSntp();
            globalTime = new Date(parseInt(data.sntp_year,10),parseInt(data.sntp_month,10)-1, parseInt(data.sntp_day,10), parseInt(data.sntp_hour,10), parseInt(data.sntp_minute,10), parseInt(data.sntp_second,10));
            self.day = ko.observable();
            self.localTime = ko.observable();
            self.updateCurrentTime;
            self.currentYear = ko.observable(parseInt(data.sntp_year,10));
            self.currentMonth = ko.observable(parseInt(data.sntp_month,10));
            self.currentDate = ko.observable(parseInt(data.sntp_day,10));
            self.currentHour = ko.observable(parseInt(data.sntp_hour,10));
            self.currentMinute = ko.observable(parseInt(data.sntp_minute,10));
            self.years = ko.observableArray(sntpYears);
            self.months = ko.observableArray(sntpMonths);

            /*
             当用户选择月份的时候改变日期选择框的选项
             */
            self.initDateList = function(){
                initDateList();
                self.dates(sntpDates);
            }

            //初始化日期列表
            initDateList();
            self.dates = ko.observableArray(sntpDates);
            self.hours = ko.observableArray(sntpHours);
            self.minutes = ko.observableArray(sntpMinutes);

            self.updateCurrentTime = function() {
                $("#sntpForm #weekend").removeAttr("trans");
                self.day( $.i18n.prop(weekends[globalTime.getDay()]));
                // $("#sntpForm #weekend").attr("trans", $.i18n.prop(weekends[globalTime.getDay()]));
                var localCurrentTime = "";
                localCurrentTime = globalTime.getFullYear() + "-" + getTwoDigit(globalTime.getMonth()+1) + "-" + getTwoDigit(globalTime.getDate()) + " " + getTwoDigit(globalTime.getHours()) + ":" + getTwoDigit(globalTime.getMinutes()) + " :" + getTwoDigit(globalTime.getSeconds());
                self.localTime(localCurrentTime);
                globalTime.setTime(globalTime.getTime()+1000);
            };
            function initDateList(){
                sntpDates = [];
                if($.inArray(parseInt(self.currentMonth(),10), bigMonth) != -1) {
                    produceArray(1, 31, sntpDates);
                } else if($.inArray(parseInt(self.currentMonth(),10), smallMonth) != -1) {
                    produceArray(1, 30, sntpDates);
                } else if(parseInt(self.currentYear(),10)%4 == 0) {
                    produceArray(1, 29, sntpDates);
                } else {
                    produceArray(1, 28, sntpDates);
                }
            }

            /**
             * 设定,新增,删除回调函数
             * @method callback
             */
            self.callback = function(result) {
                if (result.result) {
                    clearIntervalTimer();
                    init(self);
                    successOverlay();
                } else {
                    errorOverlay();
                }
            };
            self.save = function() {
                var requestParams = {
                    goformId: "SNTP",
                    time_year : self.currentYear(),
                    time_month : self.currentMonth(),
                    time_day : self.currentDate(),
                    time_hour : self.currentHour(),
                    time_minute : self.currentMinute()
                };
                showLoading();
                service.setSntpSetting(requestParams,self.callback);
            };
        }

        /**
         * 初始化sleep mode view model
         * @method init
         */
        function init() {
            var container = $('#container');
            ko.cleanNode(container[0]);
            var vm = new DataModeVM();
            ko.applyBindings(vm, container[0]);
            vm.updateCurrentTime();
            addInterval(function(){
                vm.updateCurrentTime();
            }, 1000);
        }
        return {
            init : init
        };
    });