$(document).bind('mobileinit', function(){
    $.mobile.ajaxEnabled = false;
    $.mobile.pushStateEnabled = false;
    $.mobile.hashListeningEnabled = false;
});
function util() {
    function changePageByHash(hash) {
        if (hash.substring(0) != "#") {
            hash = "#" + hash;
        }
        window.location.hash = hash;
    }

    function changePageByUrl(url) {
        window.location.href = url;
    }

    function showConfirm(msg) {
        return confirm(msg);
    }

    function showAlert(msg) {
        alert(msg);
    }

    function translate(lang) {
        if (!lang) {
            var data = service.getLanguage();
            lang = data.Language;
        }

        $.i18n.properties({
            name:['Messages'],
            path:'i18n/',
            mode:'map',
            cache:true,
            language:lang,
            callback:function () {
                $("body").find("*[trans]").each(function () {
                    var trans = $(this).attr("trans");
                    if (trans != "") {
                        var word = $.i18n.prop(trans);
                        var nodeName = this.nodeName.toUpperCase();
                        if (nodeName == 'INPUT') {
                            $(this).val(word);
//                var type = this.type.toUpperCase();
//                if (type == "BUTTON" || type == "SUBMIT" || type == "RESET" || type == "CHECKBOX" ) {
                            $(this).button('refresh');
//                }
                        } else if (nodeName == 'SELECT') {
                            $(this).val(word);
                            $(this).selectmenu('refresh');
                        } else if (nodeName == 'OPTION') {
                            $(this).text(word);
                            $(this).parent().selectmenu('refresh');
                        } else if (nodeName == 'BUTTON') {
                            $(this).text(word);
                            $(this).button('refresh');
                        } else if (nodeName == 'A') {
                            $(this).find(".ui-btn-text").text(word);
                        } else {
                            $(this).html(word);
                        }
                    }
                });
            }
        });
    }

    function showLoading(){
        $.mobile.showPageLoadingMsg("a", "loading....", false);
    }
    function hideLoading(){
        window.setTimeout(function () {
            $.mobile.hidePageLoadingMsg();
        }, 500);
    }

    function setCookie(name, value, expireHour) {
        var str = name + "=" + escape(value);
        if (expireHour > 0) {
            var date = new Date();
            var ms = expireHour * 3600 * 1000;
            date.setTime(date.getTime() + ms);
            str += "; expires=" + date.toGMTString();
        }
        document.cookie = str;
    }

    function getCookie(name) {
        var arrStr = document.cookie.split("; ");
        for (var i = 0; i < arrStr.length; i++) {
            var temp = arrStr[i].split("=");
            if (temp[0] == name) return unescape(temp[1]);
        }
    }

    function deleteCookie(name) {
        var date = new Date();
        date.setTime(date.getTime() - 10000);
        document.cookie = name + "=; expires=" + date.toGMTString();
    }

    function isLoggedIn() {
        var info = service.getLoginStatus();
        if (info.status != "loggedIn") {
            util.showAlert($.i18n.prop("You need to login"));
            util.changePageByUrl("index.html");
            return false;
        }
        return true;
    }

    function isSIMCardOK(state) {
        if (!state) {
            var data = service.getSIMCardStatus()
            state = data.modem_main_state;
        }
        var result = false;
        if (state == "modem_waitpin") {
            util.showAlert($.i18n.prop("modem_waitpin_alert"));
        }
        else if (state == "modem_waitpuk") {
            util.showAlert($.i18n.prop("modem_waitpuk_alert"));
        }
        else if (state == "modem_imsi_waitnck") {
            util.showAlert($.i18n.prop("modem_imsi_waitnck_alert"));
        }
        else if (state == "modem_sim_undetected") {
            util.showAlert($.i18n.prop("modem_sim_undetected_alert"));
        }
        else if (state == "modem_sim_destroy") {
            util.showAlert($.i18n.prop("modem_sim_destroy_alert"));
        } else {
            result = true;
        }
        if (!result) {
            util.changePageByUrl("index.html");
        }
        return result;
    }

    return {
        changePageByHash:changePageByHash,
        changePageByUrl:changePageByUrl,
        showConfirm:showConfirm,
        showAlert:showAlert,
        translate:translate,
        showLoading:showLoading,
        hideLoading:hideLoading,
        setCookie:setCookie,
        getCookie:getCookie,
        deleteCookie:deleteCookie,
        isLoggedIn:isLoggedIn,
        isSIMCardOK:isSIMCardOK
    }
}
var util = util();