/**
 * @module dns_filter
 * @class dns_filter
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore' ],

    function($, ko, config, service, _) {

        var columnsTmpl = [
            { columnType:"radio", rowText:"dnsRule", width:"3%" },
			{ headerTextTrans:"dns_list_id", rowText:"index", width:"3%"},
            { headerTextTrans:"dns_list_url", rowText:"dnsRule", width:"20%" }
        ];
        /**
         * prot_map VM
         * @class PortMapVM
         */
        function PortMapVM() {
            var self = this;
            var info = getDnsMap();
	    self.dnsRule = ko.observable('');
	   // self.rules = ko.observableArray(info.dnsMapRules);
            self.gridTemplate = new ko.simpleGrid.viewModel({
                data:info.dnsMapRules,
                idName:"dnsRule",
                columns:columnsTmpl,
                tmplType:'list',
                pageSize: 10
            });
       

        /**
         * 设定,新增,删除回调函数
         * @method callback
         */
        self.callback = function(result) {
            if (result.result == "success") {
                clear();
                init(self);
                successOverlay();
            } else {
                errorOverlay();
            }
        };
        /**
         * 情况添加规则输入
         * @method clear
         */
        function clear() {
            self.dnsRule('');
        }
        /**
         * 保存规则
         * @method save
         */
        self.save = function() {
            if(self.gridTemplate.data().length >= config.dnsMax) {
                showAlert({msg: "rules_max", params: config.dnsMax});
                return;
            }
            if(self.checkExist()) {
                showAlert("rule_exist");
                return;
            }
            showConfirm("confirm_data_add_restart",function(){
                showLoading();
                var params = {};
                params.dnsRule = self.dnsRule();
                service.setDnsMap(params,self.callback);
            })
        };
            /**
             * 检查新增规则是否已经存在
             * @method checkExist
             */
            self.checkExist = function() {
                var newRule = {
                    dnsRule: self.dnsRule()
                };
                var oldRule;
                info = getDnsMap();
                for(var i = 0; i < info.dnsMapRules.length; i++) {
                    oldRule = {
                        dnsRule: info.dnsMapRules[i].dnsRule
                    };

                    if(_.isEqual(newRule, oldRule)) {
                        return true;
                    }
                }
                return false;
            };

            /**
         * 删除规则
         * @method deleteMapRules
         */
        self.deleteDnsRule = function() {
            var ids = self.gridTemplate.radioSelectValue();
            if(_.isUndefined(ids)) {
                showAlert("no_data_selected");
                return;
            }
            showConfirm("confirm_data_delete_restart", function () {
                showLoading();
                var params = {};
                params.indexs = ids;
                service.deleteDnsRule(params,self.callback);
            });
        };
	  }
        /**
         * 获取port map信息
         * @method getDnsMap
         */
        function getDnsMap() {
            return service.getDnsMap();
        }
        /**
         * 初始化port map view model
         * @method init
         */
        function init(viewModel) {
            var vm;
            if(viewModel) {
                vm = viewModel;
                var info = getDnsMap();
              //  vm.rules(info.dnsMapRules);
                vm.gridTemplate.data(info.dnsMapRules);
                refreshTableHeight();
                return;
            }

            vm = new PortMapVM();
            var container = $('#container');
            ko.cleanNode(container[0]);
            ko.applyBindings(vm, container[0]);

            fixTableHeight();

            $('#dnsMapListForm').validate({
                submitHandler : function() {
                    vm.deleteDnsRule();
                }
            });

            $('#dnsMapForm').validate({
                submitHandler : function() {
                    vm.save();
                },
                rules: {
					txtDns:"dns_check"
                },
				 errorPlacement: function(error, element) {
                if(element.attr("name") == "txtDns") {
                    error.insertAfter("#dnsExamLabel");
                }else
                    error.insertAfter(element);
            }
            });
        }
        return {
            init : init
        };
    });