﻿define([ 'jquery', 'service', 'knockout', 'config/config' ], function($, service, ko, config) {

	function DeviceInformationViewModel() {
		var self = this;
		var data = service.getDeviceInfo();
		self.ssid = ko.observable(verifyDeviceInfo(data.ssid));
        self.passPhrase = ko.observable();
        self.showPassPhrase = ko.observable(data.authMode != "OPEN");
        if(self.showPassPhrase()){
            self.passPhrase(verifyDeviceInfo(data.passPhrase));
        }

        self.m_ssid = ko.observable(verifyDeviceInfo(data.m_ssid));
        self.m_passPhrase = ko.observable();
        self.m_showPassPhrase = ko.observable(data.m_authMode != "OPEN");
        if(self.m_showPassPhrase()){
            self.m_passPhrase(verifyDeviceInfo(data.m_passPhrase));
        }
        self.m_max_access_num = ko.observable(verifyDeviceInfo(data.m_max_access_num));
        self.showMssid = ko.observable(data.multi_ssid_enable == "1" && config.HAS_MULTI_SSID);
		self.ipAddress = ko.observable(verifyDeviceInfo(data.ipAddress));
		self.wanIpAddress = ko.observable(verifyDeviceInfo(data.wanIpAddress));
		self.ipv6WanIpAddress = ko.observable(verifyDeviceInfo(data.ipv6WanIpAddress));
		self.macAddress = ko.observable(verifyDeviceInfo(data.macAddress));
		self.simSerialNumber = ko.observable(verifyDeviceInfo(data.simSerialNumber));
		self.lanDomain = ko.observable(verifyDeviceInfo(data.lanDomain));
		self.imei = ko.observable(verifyDeviceInfo(data.imei));
		self.sw_version = ko.observable(verifyDeviceInfo(data.web_version));
		self.fw_version = ko.observable(verifyDeviceInfo(data.fw_version));
		self.hw_version = ko.observable(verifyDeviceInfo(data.hw_version));
		self.pro_name = ko.observable(verifyDeviceInfo(data.pro_name));
		self.max_access_num = ko.observable(verifyDeviceInfo(data.max_access_num));
        self.showMacAddress = ko.observable(config.SHOW_MAC_ADDRESS);
        self.hasWifi = ko.observable(config.HAS_WIFI);
        var ipv6Mode = data.ipv6PdpType.toLowerCase().indexOf("v6") > 0;
        //self.showIpv6WanIpAddr = ko.observable(config.IPV6_SUPPORT && ipv6Mode);
		self.showIpv6WanIpAddr = ko.observable();
		self.showIpv4WanIpAddr = ko.observable();
        self.dnsPriAddrV4 = ko.observable(verifyDeviceInfo(data.dnsPriAddrV4));
        self.dnsSecAddrV4 = ko.observable(verifyDeviceInfo(data.dnsSecAddrV4));
        self.dnsPriAddrV6 = ko.observable(verifyDeviceInfo(data.dnsPriAddrV6));
        self.dnsSecAddrV6 = ko.observable(verifyDeviceInfo(data.dnsSecAddrV6));
        self.lanNetmask = ko.observable(verifyDeviceInfo(data.lanNetmask));
        self.wanNetmask = ko.observable(verifyDeviceInfo(data.wanNetmask));
        self.pppStatus = ko.observable(getConnectStatus(data.pppStatus));
        self.networkProvider = ko.observable(verifyDeviceInfo(data.networkProvider));

		if(config.IPV6_SUPPORT){//支持IPV6
			if(data.pdpType=="IP"){//ipv4
				self.showIpv6WanIpAddr(false);
				self.showIpv4WanIpAddr(true);
			}else if(ipv6Mode){//ipv6(&ipv4)
				if(data.ipv6PdpType=="IPv6"){
					self.showIpv6WanIpAddr(true);
					self.showIpv4WanIpAddr(false);
				}else{
					self.showIpv6WanIpAddr(true);
					self.showIpv4WanIpAddr(true);
				}
			}
		}else{//不支持IPV6
			self.showIpv6WanIpAddr(false);
			self.showIpv4WanIpAddr(true);
		}		
		
        self.wifiRange = ko.observable("wifi_" + data.wifiRange);
	}
    function getConnectStatus(status){
        var connectStatus;
        if (status == "ppp_connecting") {
            connectStatus="ppp_connecting";
        } else if(status == "ppp_disconnecting"){
            connectStatus="ppp_disconnecting";
        }else if(status == "ppp_disconnected"){
            connectStatus="ppp_disconnected";
        }else{
            connectStatus="ppp_connected";
        }
        $("#connectStatus").attr("trans", connectStatus);
        return connectStatus;
    }
	function verifyDeviceInfo(field){
		if(field && field!=""){
			return field;
		}else{
			return "— —";
		}
	}

	function init() {
		var container = $('#container')[0];
		ko.cleanNode(container);
		var vm = new DeviceInformationViewModel();
		ko.applyBindings(vm, container);
	}

	return {
		init : init
	};
});