﻿define([ 'jquery', 'service', 'knockout', 'config/config','lib/jquery/jQuery.fileinput' ], function($, service, ko, config,fileinput) {

    function DeviceInformationViewModel() {
        var self = this;
        self.logs = ko.observable();
        // parseLog();

        self.callback = function(data){
            if(data.result == "success"){
                init(self);
                successOverlay();
            }else{
                errorOverlay();
            }
        }

        self.deleteSysLogs = function(){
            showConfirm("delete_logs",function(){
                showLoading();
                var params = {};
                service.deleteLogs(params,self.callback);
            })
        }
        self.parseLog = function(){
            $.ajax({
                url: "/sys_log.txt?rd="+ new Date(),
                success: function(data){
                    self.logs(data);
                },
                dataType: "text"
            });
        }
        self.parseLog();

    }
    /*  function parseLog(){
     $.ajax({
     url: "/sys_log.txt?rd="+ new Date(),
     success: function(data){
     $("#logs").val(data);
     },
     dataType: "text"
     });
     }*/
    function init() {
        var container = $('#container')[0];
        ko.cleanNode(container);
        var vm = new DeviceInformationViewModel();
        ko.applyBindings(vm, container);
        addInterval( vm.parseLog, 1000);
    }

    return {
        init : init
    };
});