#!/bin/sh
#

product_type=`cfg get product_type`

apn_mode=`cfg get pdp_type`

ipv6_radvd=`cfg get ipv6_radvd`

if [ "$ipv6_radvd" = "1" ];then
	sh /usr/zte/zte_conf/scripts/ipv6_init_radvd.sh &
	exit
fi

echo 2 > /proc/sys/net/ipv6/conf/all/forwarding
echo 2 > /proc/sys/net/ipv6/conf/rmnet1/accept_ra
echo 2 > /proc/sys/net/ipv6/conf/rmnet0/accept_ra
echo 2 > /proc/sys/net/ipv6/conf/all/proxy_ndp


if [ "$apn_mode" = "IPv6" ];then
	wan_dev_name="rmnet0"
elif [ "$apn_mode" = "IPv4v6" ];then
	wan_dev_name="rmnet1"
else
	exit
fi

ip -6 route del default
ip -6 route add default dev $wan_dev_name	

# datacard(nat), just setup usb0, radish cant handle ecm0
turbo_nat_flag=`cat /sys/class/android_usb/android0/zte_usb_rndis_ecm_net`
if [ "NO_DRIVER_DATA_CARD" = "$product_type" -o "DRIVER_DATA_CARD" = "$product_type" ]
then
  echo "ipv6_init.sh: $product_type host(less) datacard, just setup usb interface"
  if [ "$turbo_nat_flag" == "1" ] ; then
    lan_dev_name="usb0"
  elif [ "$turbo_nat_flag" == "2" ] ; then
    lan_dev_name="bridge0"
  else
    lan_dev_name="usb0"
    echo "bridge_setup.sh:the interface is not usb0 or ecm0, default usb0"
  fi
else
  echo "ipv6_init.sh: ufi mode"
  lan_dev_name='bridge0'
fi

# here we wait lan ready
while [ ! -d "/sys/class/net/$lan_dev_name" ]
 do
  sleep 1
  echo "ipv6_init.sh: wait $lan_dev_name ..."
done

echo "ipv6_init.sh: $lan_dev_name exist, go ..."

killall -9 radish
radish -b $wan_dev_name -i $wan_dev_name -x -i $lan_dev_name -x &

echo "ipv6_init.sh: done ..."
