#!/bin/sh
#
#exit
product_type=`zte_nvc_apps read product_type`

echo 2 > /proc/sys/net/ipv6/conf/all/forwarding
echo 2 > /proc/sys/net/ipv6/conf/rmnet1/accept_ra
echo 2 > /proc/sys/net/ipv6/conf/all/proxy_ndp

ip -6 route del default
ip -6 route add default dev rmnet1

killall -9 radish
if [ "NO_DRIVER_DATA_CARD" = "$product_type" -o "DRIVER_DATA_CARD" = "$product_type" ]
then
  echo "ipv6_init.sh: $product_type host(less) datacard, just setup usb0"
  lan_dev_name='usb0'
else
  echo "ipv6_init.sh: need set br0, just go"
  lan_dev_name='br0'
fi

while [ ! -d "/sys/class/net/$lan_dev_name" ]
 do
   sleep 1
   echo "ipv6_init.sh: wait $lan_dev_name ..."
done

radish -i rmnet1 -x -i $lan_dev_name -x > /dev/null 2>&1 &
radish -i rmnet1 -x -i $lan_dev_name -x > /dev/null 2>&1 &
echo "ipv6_init.sh: done ..." > /var/ipv6_rlt.log

