#!/bin/sh

stop_wpa_supplicant()
{
#killall wpa_supplicant
if [ `ps -e | grep wpa_supplicant | grep -v grep | wc -l` -ge 1 ]
then
/usr/sbin/wpa_cli disconnect
echo "/usr/sbin/wpa_cli disconnect"
sleep 2
/usr/sbin/wpa_cli terminate
echo "/usr/sbin/wpa_cli terminate"
sleep 2
fi
while [ `ps -e | grep wpa_supplicant | grep -v grep | wc -l` -ge 1 ]
do
echo "wpa_supplicant running stop it"
sleep 1
killall -2 wpa_supplicant
done
}

stop_wpa_cli()
{
#killall wpa_cli
while [ `ps -e | grep wpa_cli | grep -v grep | wc -l` -ge 1 ]
do
echo "wpa_cli running stop it"
sleep 1
killall wpa_cli
done
}

start_eapsim()
{
  wlarm down
  wlarm wsec 0
  wlarm auth 0
  wlarm -i eth0 sup_wpa 0
  wlarm -i eth0 wpa_auth 0
  wlarm up
	stop_eapsim
	sleep 1
	/usr/sbin/wpa_supplicant -Dwext -ieth0 -c/usr/sbin/wpa_supplicant.conf -dddd &
	sleep 2
	/usr/sbin/wpa_cli select_network
	echo running > /var/eapsim.run
}

stop_eapsim()
{
	echo "stop eapsim"
	stop_wpa_supplicant
	stop_wpa_cli
	rm -f /var/eapsim.run
	ifconfig eth0 up
	
}

stopall_eapsim()
{
	echo "stopall_eapsim"
	stop_wpa_supplicant
	stop_wpa_cli
	rm -f /var/eapsim.run
}

timeoutset_eapsim()
{
if [ `ps -e | grep wpa_supplicant | grep -v grep | wc -l` -ge 1 ]
then
/usr/sbin/wpa_cli timeoutset
echo "/usr/sbin/wpa_cli timeoutset"
fi
}

identitydel_eapsim()
{
if [ `ps -e | grep wpa_supplicant | grep -v grep | wc -l` -ge 1 ]
then
/usr/sbin/wpa_cli identitydel $identity_num
echo "/usr/sbin/wpa_cli identitydel $identity_num"
fi
}

identityrefresh_eapsim()
{
if [ `ps -e | grep wpa_supplicant | grep -v grep | wc -l` -ge 1 ]
then
/usr/sbin/wpa_cli identityrefresh
echo "/usr/sbin/wpa_cli identityrefresh"
fi
}

case $1 in
  start) OP=$1;;
  stop)  OP=$1;;
  timeoutset)  OP=$1;;
  identitydel)  OP=$1;;
  identityrefresh)  OP=$1;;
  stopall)  OP=$1;;
esac
OPFUN=_eapsim
echo "...$OP$OPFUN"
if [ $1=identitydel ]
then
identity_num=$2
echo "identity_num=$identity_num"
fi
$OP$OPFUN