#!/bin/sh
#	@author Forrest Lin
#	@date	2012/06/28
#	@brief
#		dhcp6c script, we keep the naming the same as dhcpv4
#

[ -z "${REASON}" ] && echo "Error: should specify the invoked reason from dhcp6c" && exit 1
[ -z "${interface}" ] && echo "Error: should specify the interface from dhcp6c" && exit 1

set_options()
{
	if [ -n "${new_domain_name_servers}" ] ; then
		sncfg set nm.config.${interface}.dhcp6.dnssrv "${new_domain_name_servers}"
	fi
	if [ -n "${new_ntp_servers}" ] ; then
		sncfg set nm.config.${interface}.dhcp6.ntpsrv "${new_ntp_servers}"
	fi
	if [ -n "${new_domain_name}" ] ; then
		sncfg set nm.config.${interface}.dhcp6.domain "${new_domain_name}"
	fi
	if [ -n "${new_sip_servers}" ] ; then
		sncfg set nm.config.${interface}.dhcp6.sipsrv "${new_sip_servers}"
	fi
	if [ -n "${new_sip_name}" ] ; then
		sncfg set nm.config.${interface}.dhcp6.sipdomain "${new_sip_name}"
	fi
	if [ -n "${new_nis_servers}" ] ; then
		sncfg set nm.config.${interface}.dhcp6.nissrv "${new_nis_servers}"
	fi
	if [ -n "${new_nis_name}" ] ; then
		sncfg set nm.config.${interface}.dhcp6.nisdomain "${new_nis_name}"
	fi
	if [ -n "${new_nisp_servers}" ] ; then
		sncfg set nm.config.${interface}.dhcp6.nispsrv "${new_nisp_servers}"
	fi
	if [ -n "${new_nisp_name}" ] ; then
		sncfg set nm.config.${interface}.dhcp6.nispdomain "${new_nisp_name}"
	fi
	if [ -n "${new_bcmcs_servers}" ] ; then
		sncfg set nm.config.${interface}.dhcp6.bcmcssrv "${new_bcmcs_servers}"
	fi
	if [ -n "${new_bcmcs_name}" ] ; then
		sncfg set nm.config.${interface}.dhcp6.bcmcsdomain "${new_bcmcs_name}"
	fi
	if [ -n "${new_iana}" ] ; then
		sncfg set nm.config.${interface}.dhcp6.ia_na "${new_iana}"
		# 
		# wide-dhcpv6 uses legacy ioctl(ifreq) to add addresses,
		# we use ip -6 addr change for for preferred lifetime and valid lifetime.
		#
		echo "${new_iana}" > /tmp/dhcp6c-${interface}.ip6
		OIFS="${IFS}"
		IFS=","
		for elem in ${new_iana} ; do
			echo "${elem}" >> /tmp/dhcp6c-${interface}.ip6
			ip6=$(echo ${elem} | cut -d " " -f 1)
			preferred_lft=$(echo ${elem} | cut -d " " -f 2)
			valid_lft=$(echo ${elem} | cut -d " " -f 3)
			echo "ip -6 addr change ${ip6}/128 preferred_lft ${preferred_lft} valid_lft ${valid_lft} dev ${interface}" >> /tmp/dhcp6c-${interface}.ip6
			ip -6 addr change ${ip6}/128 preferred_lft ${preferred_lft} valid_lft ${valid_lft} dev ${interface}
		done
		IFS="${OIFS}"
        fi
	if [ -n "${new_iapd}" ] ; then
		sncfg set nm.config.${interface}.dhcp6.ia_pd "${new_iapd}"
	fi
}

case "${REASON}" in
	INFOREQ)
		set_options
		nmc ${interface} inform dhcpv6
		;;	
	REQUEST|CONFIRM)
		set_options
		nmc ${interface} bound dhcpv6
		;;
	RENEW|REBIND)
		set_options
		nmc ${interface} renew dhcpv6
		;;
	RELEASE)
		nmc ${interface} deconfig dhcpv6
		;;
esac

exit 0
