#!/bin/sh
# ===========================================================
# get_local_ipv6addr.sh
# create by gaojingbo00139729 2016.06.16

# here we check product mode
product_type=`cfg get product_type`

echo "get_local_ipv6addr.shproduct_type is $product_type"

# only data card mode
if [ "ONLY_DATA_CARD" = "$product_type" ]
then
  echo "get_local_ipv6addr.sh: $product_type only data card mode, exit"
  exit
else
  echo "get_local_ipv6addr.sh: $product_type will check product type further"
fi

turbo_nat_flag=`cat /sys/class/android_usb/android0/zte_usb_rndis_ecm_net`

if [ "$turbo_nat_flag" == "1" ] ; then
    inte_name="usb0"
elif [ "$turbo_nat_flag" == "2" ] ; then
    inte_name="ecm0"
else
   echo "get_local_ipv6addr.sh:the interface is not usb0 or ecm0"
fi

if [ "NO_DRIVER_DATA_CARD" = "$product_type" -o "DRIVER_DATA_CARD" = "$product_type" ]
then
   if [ "$inte_name" == "usb0" ]
   then
     br0_v6_addr=`ifconfig $inte_name | grep fe80 | awk '{print $3}' | sed 's/\/64//g'`
     echo "get_local_ipv6addr.sh:datacard no bridge0, just get ipv6addr $br0_v6_addr from usb0 interface"
   else
     br0_v6_addr=`ifconfig bridge0 | grep fe80 | awk '{print $3}' | sed 's/\/64//g'`
     echo "get_local_ipv6addr.sh:datacard has bridge0, just get ipv6addr $br0_v6_addr from bridge0"
   fi
 else
   br0_v6_addr=`ifconfig bridge0 | grep fe80 | awk '{print $3}' | sed 's/\/64//g'`
   echo "get_local_ipv6addr.sh: no datacard, has bridge0, just get ipv6addr $br0_v6_addr from bridge0"
 fi
 
 cfg set br0_ipv6_addr=$br0_v6_addr