#!/bin/sh
# ===========================================================
# usage: nat.sh
# just for rmnet0 up call
mss_del_path="/tmp/mss_del.sh"
wan_if=$1
var=40
mtu=`cfg get mtu`
tcp_mss=`cfg get tcp_mss`

if [ "$wan_if" = "" ]
then
	wan_if=rmnet0
fi

if [ "$mtu" = "" -a "$tcp_mss" = "" ]
then
	mtu=1500
	tcp_mss=1460
fi

if [ "$mtu" = "" -a "$tcp_mss" != "" ]
then
	mtu=$[$tcp_mss+$var]
fi

if [ "$mtu" != "" -a "$tcp_mss" = "" ]
then
	tcp_mss=$[$mtu-$var]
fi

echo "nat.sh: wan if name is [$wan_if], mtu=[$mtu], tcp_mss=[$tcp_mss]"

echo 1 > /proc/sys/net/ipv4/ip_forward

iptables -t nat -D POSTROUTING 1
iptables -t nat -D POSTROUTING 1
iptables -t nat -A POSTROUTING -o $wan_if -j MASQUERADE

sh $mss_del_path
#busybox ifconfig $wan_if mtu $mtu
#iptables -t mangle -I POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $tcp_mss

if [ "$wan_if" = "rmnet0" ]
then
    busybox ifconfig $wan_if mtu $mtu
	if [ "$tcp_mss" != 1460 ]
	then
		
		iptables -t mangle -I POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $tcp_mss
		echo iptables -t mangle -D POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $tcp_mss > $mss_del_path
	fi
fi
