#!/bin/sh
# ===========================================================
# usage: nat.sh
# just for rmnet0 up call

wan_if=$1

mtu=`cfg get mtu`
tcp_mss=`cfg get tcp_mss`

if [ "$wan_if" = "" ]
then
	wan_if=rmnet0
fi

if [ "$mtu" = "" ]
then
	mtu=1500
fi

if [ "$tcp_mss" = "" ]
then
	tcp_mss=1460
fi

echo "nat.sh: wan if name is [$wan_if], mtu=[$mtu], tcp_mss=[$tcp_mss]"

echo 1 > /proc/sys/net/ipv4/ip_forward

iptables -t nat -D POSTROUTING 1
iptables -t nat -D POSTROUTING 1
iptables -t nat -A POSTROUTING -o $wan_if -j MASQUERADE


#busybox ifconfig $wan_if mtu $mtu
#iptables -t mangle -I POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $tcp_mss

if [ "$wan_if" = "rmnet0" ]
then

    busybox ifconfig $wan_if mtu $mtu
    iptables -t mangle -I POSTROUTING -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss $tcp_mss
fi
