﻿/**
 * 参数配置
 * @module config
 * @class config
 */
define(function() {
	var config = {
        HAS_LOGIN:true,//是否有登录页面
		defaultRoute : '#login',
        GUEST_HASH: ['#httpshare_guest'],
		THEME : 'mac',
		DEVICE: 'ufi/mf70',
		HAS_MULTI_SSID: false,//多ssid功能
        HAS_WIFI: true,  //是否包含wifi功能
        HAS_BATTERY: true, //是否有电池
        SHOW_MAC_ADDRESS: false, //是否显示mac地址
        IPV6_SUPPORT: true, //是否支持ipv6
        USE_IPV6_INTERFACE:true,//使用IPV6相关新接口。使用方法，例如使用MF92时，设置为false。
        MAX_STATION_NUMBER: 10, //WIFI最大连接数
        NETWORK_UNLOCK_SUPPORT:true,//是否支持解锁
        WIFI_BAND_SUPPORT: false, //是否支持wifi频段设置
        WIFI_BANDWIDTH_SUPPORT: false, //是否支持频带宽度
        ALREADY_NOTICE:false,//是否已经提醒，有在线升级信息
        AP_STATION_SUPPORT:false,//是否支持AP Station功能
        AP_STATION_LIST_LENGTH:10,
        HAS_PHONEBOOK:true,//是否有电话本功能
        HAS_SMS:true,//是否有短信功能
        WEBUI_TITLE: '3G Hostless Modem', //title配置, 具体参考各设备下的配置
        //modem_main_state的临时状态，一般需要界面轮询等待
        TEMPORARY_MODEM_MAIN_STATE:["modem_undetected", "modem_detected", "modem_sim_state", "modem_handover", "modem_imsi_lock", "modem_online", "modem_offline"],
        SHOW_APN_DNS:false,//APN设置页面是否显示DNS，不显示则dnsMode默认设置为auto
		WIFI_SWITCH_SUPPORT: false,//新增用于MF70型号Wi-Fi开关
        CONTENT_MODIFIED:{
            modified:false,
            message:'leave_page_info',
            data:{},
            checkChangMethod:function () {
                return false;
            },
            callback:{ok:$.noop, no:function () {
                return true;
            }}//如果no返回true,页面则保持原状
        }, //当前页面内容是否已经修改

        resetContentModifyValue:function () {
            this.CONTENT_MODIFIED.checkChangMethod = function () {
                return false;
            };
            this.CONTENT_MODIFIED.modified = false;
            this.CONTENT_MODIFIED.message = 'leave_page_info';
            this.CONTENT_MODIFIED.callback = {ok:$.noop, no:function () {
                return true;
            }};//如果no返回true,页面则保持原状
            this.CONTENT_MODIFIED.data = {};
        },

        /**
         * 端口转发最大规则数
         * @attribute {Integer} portForwardMax
         */
        portForwardMax: 10,
        /**
         * 出厂设置默认APN的个数
         * @attribute {Integer} defaultApnSize
         */
        defaultApnSize:1,
        /**
         * 最大APN个数
         * @attribute {Integer} maxApnNumber
         */
        maxApnNumber: 10,
		NETWORK_MODES : [ {
			name : '802.11 b/g/n',
			value : '4'
		}, {
			name : '802.11 n only',
			value : '2'
		} ],
		NETWORK_MODES_BAND : [ {
			name : '802.11 a only',
			value : '5'
		}, {
			name : '802.11 n only',
			value : '2'
		}, {
			name : '802.11 a/n',
			value : '4'
		} ],
		
    	AUTH_MODES : [  {
        	name: 'NO ENCRYPTION',
        	value: 'OPEN'
        }, {
            name : 'WPA2(AES)-PSK',
            value : 'WPA2PSK'
        },{
        	name : 'WPA-PSK/WPA2-PSK',
        	value : 'WPAPSKWPA2PSK'
        } ],
        AUTH_MODES_ALL : [  {
            name: 'NO ENCRYPTION',
            value: 'OPEN'
        }, {
            name : 'SHARED',
            value : 'SHARED'
        }, {
            name : 'WPA-PSK',
            value : 'WPAPSK'
        }, {
            name : 'WPA2-PSK',
            value : 'WPA2PSK'
        }, {
            name : 'WPA-PSK/WPA2-PSK',
            value : 'WPAPSKWPA2PSK'
        } ],

        LANGUAGES: [ { 
        	name: 'Русский',
        	value: 'ru'
        }, {
    		name: 'English',
        	value: 'en'
        }],
        
        AUTO_MODES: [ {
        	name: 'Automatic',
        	value: 'WCDMA_preferred'
        }, {
        	name: '3G Only',
        	value: 'Only_WCDMA'
        }, {
        	name: '2G Only',
        	value: 'Only_GSM'
        } ],
		APN_AUTH_MODES : [ {
			name : "NONE",
			value : "none"
		}, {
			name : "CHAP",
			value : "chap"
		}, {
			name : "PAP",
			value : "pap"
		} ],
        AD_IMAGES:[
            {url:"img/ad/ad1.jpg"},
            {url:"img/ad/ad2.jpg"},
            {url:"img/ad/ad3.jpg"},
            {url:"img/ad/ad4.jpg"}
        ],
        SMS_VALIDITY: [ {
            name: '12 hours',
            value: 'twelve_hours'
        }, {
            name: 'A day',
            value: 'one_day'
        }, {
            name: 'A week',
            value: 'one_week'
        }, {
            name: 'The longest period',
            value: 'largest'
        }],
        SLEEP_MODES : [ {
            name : "Always on",
            value : "-1"
        }, {
            name : "5 minutes",
            value : "5"
        }, {
            name : "10 minutes",
            value : "10"
        }, {
            name : "20 minutes",
            value : "20"
        }, {
            name : "30 minutes",
            value : "30"
        }, {
            name : "1 hour",
            value : "60"
        }, {
            name : "2 hours",
            value : "120"
        } ],

        FORWARD_PROTOCOL_MODES: [ {
            name : "TCP+UDP",
            value : "TCP&UDP"
        }, {
            name : "TCP",
            value : "TCP"
        }, {
            name : "UDP",
            value : "UDP"
        }],

        MAP_PROTOCOL_MODES: [ {
            name : "TCP+UDP",
            value : "TCP&UDP"
        }, {
            name : "TCP",
            value : "TCP"
        }, {
            name : "UDP",
            value : "UDP"
        }],

        FILTER_PROTOCOL_MODES: [ {
            name : "NONE",
            value : "None"
        }, {
            name : "TCP",
            value : "TCP"
        }, {
            name : "UDP",
            value : "UDP"
        }, {
            name : "ICMP",
            value : "ICMP"
        }],

        SD_SHARE_ENABLE: [ {
            name : "Enable",
            value : "1"
        }, {
            name : "Disable",
            value : "0"
        }],

        SD_FILE_TO_SHARE: [ {
            name : "entire_sd_card",
            value : "1"
        }, {
            name : "custom_setting",
            value : "0"
        }],

        SD_ACCESS_TYPE: [ {
            name : "entire_sd_card",
            value : "1"
        }, {
            name : "custom_setting",
            value : "0"
        }],

        DLNA_LANGUAGES: [ {
            name: 'english',
            value: 'english'
        }, {
            name: 'chinese',
            value: 'chinese'
        } ],
        
    	/**
    	 * SD 卡根目录
    	 * @attribute {String} SD_BASE_PATH 
    	 */
        SD_BASE_PATH: '/mmc2',

    	/**
    	 * 数据库中全部的短消息
    	 * @attribute {Array} dbMsgs 
    	 */
    	dbMsgs : [],
    	/**
    	 * 经解析关联后的所有短消息
    	 * @attribute {Array} listMsgs 
    	 */
    	listMsgs : [],

    	/**
    	 * 当前聊天对象的手机号
    	 * @attribute {String} currentChatObject 
    	 */
    	currentChatObject: null,
    	/**
    	 * 短消息最大编号
    	 * @attribute {Integer} maxId 
    	 */
    	smsMaxId : 0,
    	/**
    	 *  电话本记录 
    	 * @attribute {Array} phonebook  
    	 * */
    	phonebook : [],
        /**
         *  缓存短信初始化状态
         * @attribute {Boolean} smsIsReady
         * */
        smsIsReady: false,
        /**
         * 国家码所述类型
         * @attribute {JSON} defaultApnSize
         * @example
         * 2412-2462   1
		 * 2467-2472   2
		 * 2312-2372   4
         */
        countryCodeType : {
        	world: 3,
        	mkkc: 3,
        	apld: 7,
        	etsic: 3,
        	fcca: 1
        },
        
        /**
         * 国家码与类型匹配表
         * @attribute {Map} countryCode
         */
        countryCode : {
			world : [ "AL", "DZ", "AR", "AM", "AU", "AT", "AZ", "BH", "BY",
					"BE", "BA", "BR", "BN", "BG", "CL", "CN", "CR", "HR", "CY",
					"CZ", "DK", "EC", "EG", "SV", "EE", "FI", "FR", "F2", "GE",
					"DE", "GR", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IE",
					"IL", "IT", "JM", "JO", "KZ", "KE", "KP", "KR", "KW", "LV",
					"LB", "LI", "LT", "LU", "MO", "MK", "MY", "MT", "MC", "MA",
					"NL", "AN", "NO", "OM", "PK", "PE", "PH", "PL", "PT", "QA",
					"RO", "RU", "SA", "CS", "SG", "SK", "SI", "ZA", "ES", "LK",
					"SE", "CH", "SY", "TH", "TT", "TN", "TR", "UA", "AE", "GB",
					"UY", "VN", "YE", "ZW" ],
			mkkc : [ "JP" ],
			apld : [],
			etsic : [ "BZ", "BO", "NZ", "VE" ],
			fcca : [ "CA", "CO", "DO", "GT", "MX", "PA", "PR", "TW", "US", "UZ" ]
		}, 

        /**
         * 国家码与语言匹配表
         * @attribute {Map} countries
         */
		countries : {
			NONE : "NONE",
			AL : "SHQIPERI",
			DZ : "الجزائر",
			AR : "ARGENTIA",
			AM : "ՀԱՅԱՍՏԱՆ",
			AU : "AUSTRALIA",
			AT : "ÖSTERREICH",
			AZ : "AZƏRBAYCAN",
			BH : "البحرين",
			BY : "БЕЛАРУСЬ",
			BE : "BELGIË",
			BA : "БОСНА И ХЕРЦЕГОВИНА",
			BR : "BRASIL",
			BN : "BRUNEI DARUSSALAM",
			BG : "БЪЛГАРИЯ",
			CL : "CHILE",
			CN : "中国",
			CR : "COSTA RICA",
			HR : "HRVATSKA",
			CY : "ΚΎΠΡΟΣ",
			CZ : "ČESKÁ REPUBLIKA",
			DK : "DANMARK",
			EC : "ECUADOR",
			EG : "مصر",
			SV : "EL SALVADOR",
			EE : "EESTI",
			FI : "SUOMI",
			FR : "FRANCE",
			F2 : "FRANCE RESERVES",
			GE : "საქართველო",
			DE : "DEUTSCHLAND",
			GR : "ΕΛΛΆΔΑ",
			HN : "HONDURAS",
			HK : "香港",
			HU : "MAGYARORSZÁG",
			IS : "ÍSLAND",
			IN : "INDIA",
			ID : "INDONESIA",
			IR : "ایران، جمهوری اسلامی",
			IE : "ÉIRE",
			IL : "إسرائيل",
			IT : "ITALIA",
			JM : "JAMAICA",
			JO : "الأردن",
			KZ : "КАЗАХСТАН",
			KE : "KENYA",
			KP : "조선민주주의인민공화국",
			KR : "한국 ROK",
			K3 : "한국 ROC3",
			KW : "الكويت",
			LV : "LATVIJA",
			LB : "لبنان",
			LI : "LIECHTENSTEIN",
			LT : "LIETUVA",
			LU : "LUXEMBOURG",
			MO : "澳門",
			MK : "МАКЕДОНИЈА",
			MY : "MALAYSIA",
			MT : "MALTA",
			MC : "MONACO",
			MA : "المغرب",
			NL : "NEDERLAND",
			AN : "NETHERLANDS ANTILLES",
			NO : "NORGE",
			OM : "سلطنة عمان",
			PK : "PAKISTAN",
			PE : "PERÚ",
			PH : "PHILIPPINES",
			PL : "POLSKA",
			PT : "PORTUGAL",
			QA : "قطر",
			RO : "ROMÂNIA",
			RU : "Российская Федерация",
			SA : "السعودية",
			CS : "Црна Гора",
			SG : "SINGAPORE",
			SK : "SLOVENSKÁ REPUBLIKA",
			SI : "SLOVENIJA",
			ZA : "SOUTH AFRICA",
			ES : "ESPAÑA",
			LK : "SRILANKA",
			SE : "SVERIGE",
			CH : "SCHWEIZ",
			SY : "الجمهورية العربية السورية",
			TH : "ประเทศไทย",
			TT : "TRINIDAD AND TOBAGO",
			TN : "تونس",
			TR : "TÜRKİYE",
			UA : "Україна",
			AE : "الإمارات العربية المتحدة",
			GB : "UNITED KINGDOM",
			UY : "URUGUAY",
			VN : "VIỆT NAM",
			YE : "اليمن",
			ZW : "ZIMBABWE",
			JP : "日本",
			K2 : "한국 ROC2",
			BZ : "BELIZE",
			BO : "BOLIVIA",
			NZ : "NEW ZEALAND",
			VE : "REPÚBLICA BOLIVARIANA DE VENEZUELA",
			CA : "CANADA",
			CO : "COLOMBIA",
			DO : "REPÚBLICA DOMINICANA",
			GT : "GUATEMALA",
			MX : "MEXICO",
			PA : "PANAMÁ",
			PR : "PUERTO RICO",
			TW : "台灣",
			US : "UNITED STATES",
			UZ : "O’zbekiston"
		}
	};

    require(['config/' + config.DEVICE + '/config'], function(otherConf) {
        $.extend(config, otherConf);
    });

	return config;
});