<html>
<head>
<title><% asp_get("pageTitle"); %></title>
<link href="../style/webgui.css" rel="stylesheet" type="text/css">
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<link href="../style/dialog.css" rel="stylesheet" type="text/css" media="screen">
<script language="JavaScript" src="../js/jquery-1.6.js"></script>
<script language="JavaScript" src="../js/jquery.form.js"></script>
<script type="text/javascript" src="../js/dialog.js"></script>   
<script language="JavaScript" src="../js/common.js"></script>
<script language="JavaScript" src="../js/prompt.js"></script>
<script language="JavaScript" src="../js/overlib.js"></script>
<script language="JavaScript" src="../js/toptip.js"></script>
<script language="JavaScript" src="../js/lang.js"></script>
<script language="JavaScript" src="../js/wlan.js"></script>
<script language="JavaScript" src="../js/protect.js"></script>
<script language="JavaScript" src="../js/fw_util.js"></script>
<script language="JavaScript" type="text/javascript">
var language = '<% asp_get("Language"); %>'; 
Butterlate.lang = language;
Butterlate.setTextDomain("firewall");

/*
var rules_num = ' asp_get("IPPortRuleNums"); %>'; 
var rules = ' asp_get("IPPortFilterRules"); %>'; 
var ip_port_filter_enable = ' asp_get("IPPortFilterEnable"); %>'; 
var default_policy = ' asp_get("DefaultFirewallPolicy"); %>'; 
*/

var MAX_RULES = 10;

var rules_num = '<% getIPPortRuleNumsASP(); %>';
var rules = '<% getIPPortRulesASP(); %>';

var ruleArray = new Array();
ruleArray = rules.split(";");

function getActionType(action)
{
	var type;
	if ("Accept" == action)
		type = "1";
	else if ("Drop" == action)
		type = "0";
		
	return type;
}

function getIpAddress(ip)
{
	if (ip == "")
	{
		if(60 == ValueProductName)
			return "";
		else if(50 == ValueProductName || 51 == ValueProductName)	
			return "any/0";
	}
	else
		return ip;
}

function getPort(port)
{
	if (port == "")
		return "0";
	else
		return port;
}

function resetItems()
{
	document.ipportFilter.dFromPort.disabled = true;
	document.ipportFilter.dToPort.disabled = true;
	document.ipportFilter.sFromPort.disabled = true;
	document.ipportFilter.sToPort.disabled = true;
}

function formCheck()
{
	writeHiddenNum("lucknum_FW_BASIC");
	document.getElementById('portBasicApply').disabled = true;
	return true;
}

function zte_validateMac(val,which){
   var i;
   var sval=String(val);
	
	if (sval.length == 0)
	{
		return false;
	}

   if (sval.length>0 && sval.length!=17)
   {  
      return false;
   }

   for (i=0; i<sval.length; i++)
   {  
	  if ((i % 3)==2)
      {  
	     if (sval.charAt(i)!=':')
         {  
            return false;
         }
      }
      else if (!((sval.charAt(i)>='0' && sval.charAt(i)<='9') ||
                (sval.charAt(i)>='A' && sval.charAt(i)<='F')  ||
                (sval.charAt(i)>='a' && sval.charAt(i)<='f')))
      {  
         return false;
      }
   }
   var sub1=val.substring(0,2);
   var sub2=val.substring(3,5);
   var sub3=val.substring(6,8);
   var sub4=val.substring(9,11);
   var sub5=val.substring(12,14);
   var sub6=val.substring(15);

   if (sub1=='ff' && sub2=='ff' && sub3=='ff' && sub4=='ff' && sub5=='ff' && sub6=='ff')
   {
	return false;
   }
   if (sub1=='00' && sub2=='00' && sub3=='00' && sub4=='00' && sub5=='00' && sub6=='00')
   {
	return false;
   }
   sub1='0x'+sub1;
   if((sub1 & 1)==1)
   {
	return false;
   }
   return true;
}

function ipportFormCheck()
{
	writeHiddenNum("lucknum_FW_FILTER_ADD");
	if( document.BasicSettings.portFilterEnabled.options.selectedIndex == 0)
	{
		return true;
	}

	if(rules_num >= (MAX_RULES) )
	{
		//alert(Get_string("The rule number is exceeded")+" "+ MAX_RULES +".");
		document.getElementById("alert_string").innerHTML= Get_string("The rule number is exceeded")+" "+ MAX_RULES +".";
		dialog("","id:alert_string","300px","auto","id");	
		return false;
	}

	if( document.getElementById("sip_address").value == "" && 
		document.getElementById("dip_address").value == "" &&
		document.getElementById("sFromPort").value == "" &&
		document.getElementById("dFromPort").value == "" &&
		document.getElementById("mac_address").value == "")
	{
		ShowError2(document.ipportFilter.mac_address, 'Please enter IP MAC');
		return false;
	}
	
	if( document.getElementById("comment").value == "")
	{
		ShowError(document.ipportFilter.comment, 'Please enter comment');
		return false;
	}
	
	if (!isCharacterValid(document.ipportFilter.comment.value))
	{
		ShowError(document.ipportFilter.comment, 'comment invalid character');
		return false;
	}
	
	if (checkASC(document.ipportFilter.comment.value, "comment") == false) 
	{
		ShowError(document.ipportFilter.comment, "WIFI Basic Invalid Err");
		return false;
	}
	
	if ( checkinvalidkey(document.ipportFilter.comment.value) == false )
	{
		ShowError(document.ipportFilter.comment, "WIFI KEY Char Err");
		return false;
	}

	if (zte_validateMac(document.ipportFilter.mac_address.value,document.ipportFilter.mac_address) == false
	&& document.ipportFilter.mac_address.value != "")
		{
			   ShowError2(document.ipportFilter.mac_address,"Invalid MAC addr");
				return false;
		}
		
	document.ipportFilter.mac_address.value = document.ipportFilter.mac_address.value.toUpperCase();
		
	// check ip address format
	if(document.ipportFilter.sip_address.value != ""){
		if(! checkIpAddr(document.ipportFilter.sip_address) ){
			ShowError(document.ipportFilter.sip_address, 'IP format error');
			return false;
		}
    }
	
	if(document.ipportFilter.dip_address.value != ""){
		if(! checkIpAddr(document.ipportFilter.dip_address) ){
			ShowError(document.ipportFilter.dip_address, 'IP format error');
			return false;
		}
    }
		
	// check the port
	var protocol = document.ipportFilter.protocol.value;
	if ("TCP" == protocol || "UDP" == protocol)
	{
		
		if (document.ipportFilter.dFromPort.value == "")
		{
			ShowError(document.ipportFilter.dFromPort, 'Not set port range');
			return false;
		}
		if (document.ipportFilter.dToPort.value == "")
		{
			ShowError(document.ipportFilter.dToPort, 'Not set port range');
			return false;
		}
		
		if (document.ipportFilter.sFromPort.value == "")
		{
			ShowError(document.ipportFilter.sFromPort, 'Not set port range');
			return false;
		}
		if (document.ipportFilter.sToPort.value == "")
		{
			ShowError(document.ipportFilter.sToPort, 'Not set port range');
			return false;
		}
	}
					
	if(document.ipportFilter.sFromPort.value != ""){
		d1 = atoi(document.ipportFilter.sFromPort.value, 1);
		if((isAllNum( document.ipportFilter.sFromPort.value ) == 0)||(isInt( document.ipportFilter.sFromPort.value ) == 0)){
			//alert("Invalid port number: source port.");
			ShowError(document.ipportFilter.sFromPort, 'Invalid source port');
			//document.ipportFilter.sFromPort.focus();
			return false;
		}
		if(d1 > 65535 || d1 < 1){
			//alert("Invalid port number: source port.");
			ShowError(document.ipportFilter.sFromPort, 'Invalid source port');
			//document.ipportFilter.sFromPort.focus();
			return false;
		}
		
		if(document.ipportFilter.sToPort.value == "")
		{
			ShowError(document.ipportFilter.sToPort, 'Not set port range');
			return false;
		}
		
		if(document.ipportFilter.sToPort.value != ""){
			if((isAllNum( document.ipportFilter.sToPort.value ) == 0)||(isInt( document.ipportFilter.sToPort.value ) == 0)){
				//alert("Invalid port number: source port.");
				ShowError(document.ipportFilter.sToPort, 'Invalid source port');
				return false;
			}		
			d2 = atoi(document.ipportFilter.sToPort.value, 1);
			if(d2 > 65535 || d2 < 1){
				//alert("Invalid source port number.");
				ShowError(document.ipportFilter.sToPort, 'Invalid source port');
				return false;
			}
			if(d1 > d2){
			//alert("Invalid source port range setting.");
			ShowError(document.ipportFilter.sToPort, 'Invalid source port range');
			return false;
			}
		}
	}

	if(document.ipportFilter.dFromPort.value != ""){
		d1 = atoi(document.ipportFilter.dFromPort.value, 1);
		if((isAllNum( document.ipportFilter.dFromPort.value ) == 0)||(isInt( document.ipportFilter.dFromPort.value ) == 0)){
			//alert("Invalid port number: dest port.");
			ShowError(document.ipportFilter.dFromPort, 'Invalid dest port');
			return false;
		}
		if(d1 > 65535 || d1 < 1){
			//alert("Invalid port number: dest port.");
			ShowError(document.ipportFilter.dFromPort, 'Invalid dest port');
			return false;
		}
		
		if(document.ipportFilter.dToPort.value == "")
		{
			ShowError(document.ipportFilter.dToPort, 'Not set port range');
			return false;
		}
		
		if(document.ipportFilter.dToPort.value != ""){
			if((isAllNum( document.ipportFilter.dToPort.value ) == 0)||(isInt( document.ipportFilter.dToPort.value ) == 0)){
				//alert("Invalid port number: dest port.");
				ShowError(document.ipportFilter.dToPort, 'Invalid dest port');
				return false;
			}		
			d2 = atoi(document.ipportFilter.dToPort.value, 1);
			if(d2 > 65535 || d2 < 1)
			{
				ShowError(document.ipportFilter.dToPort, 'Invalid dest port');
				return false;
			}
			if(d1 > d2)
			{
				ShowError(document.ipportFilter.dToPort, 'Invalid dest port range');
				return false;
			}
		}
	}
	
	// check whether the rule has existed
	if(60 == ValueProductName)
	{
		var rule = getIpAddress(document.ipportFilter.sip_address.value) + ",," 
				+ getPort(document.ipportFilter.sFromPort.value) + "," 
				+ getPort(document.ipportFilter.sToPort.value) + ","
				+ getIpAddress(document.ipportFilter.dip_address.value) + ",,"
				+ getPort(document.ipportFilter.dFromPort.value) + "," 
				+ getPort(document.ipportFilter.dToPort.value) + ","
				+ getProtocolType(document.ipportFilter.protocol.value) + ","
				+ getActionType(document.ipportFilter.action.value) + ","
				+ document.ipportFilter.comment.value + ","
				+ document.ipportFilter.mac_address.value;
	}
	else if(50 == ValueProductName || 51 == ValueProductName)
	{	
		var rule = getIpAddress(document.ipportFilter.sip_address.value) + ",0," 
				+ getPort(document.ipportFilter.sFromPort.value) + "," 
				+ getPort(document.ipportFilter.sToPort.value) + ","
				+ getIpAddress(document.ipportFilter.dip_address.value) + ",0,"
				+ getPort(document.ipportFilter.dFromPort.value) + "," 
				+ getPort(document.ipportFilter.dToPort.value) + ","
				+ getProtocolType(document.ipportFilter.protocol.value) + ","
				+ getActionType(document.ipportFilter.action.value) + ","
				+ document.ipportFilter.comment.value + ","
				+ document.ipportFilter.mac_address.value;
	}
	if (isRuleExist(rule))
	{
		ShowError(document.ipportFilter.comment, 'Rule has existed');
		return false;
	}
	
	document.getElementById('portFilterApply').disabled = true;
	return true;
}


function defaultPolicyChanged()
{
	if( document.BasicSettings.defaultFirewallPolicy.options.selectedIndex == 0){
		document.ipportFilter.action.options.selectedIndex = 0;
	}else
		document.ipportFilter.action.options.selectedIndex = 1;
}

function protocolChange()
{
	if( document.ipportFilter.protocol.options.selectedIndex == 1 
	   || document.ipportFilter.protocol.options.selectedIndex == 2) {
	   //|| document.ipportFilter.protocol.options.selectedIndex == 3){
		document.ipportFilter.dFromPort.disabled = false;
		document.ipportFilter.dFromPort.value = 1;
		document.ipportFilter.dToPort.disabled = false;
		document.ipportFilter.dToPort.value = 65535;
		document.ipportFilter.sFromPort.disabled = false;
		document.ipportFilter.sFromPort.value = 1;
		document.ipportFilter.sToPort.disabled = false;
		document.ipportFilter.sToPort.value = 65535;
	}else{
		document.ipportFilter.dFromPort.disabled = true;
		document.ipportFilter.dToPort.disabled = true;
		document.ipportFilter.sFromPort.disabled = true;
		document.ipportFilter.sToPort.disabled = true;

		document.ipportFilter.dFromPort.value = "";
		document.ipportFilter.dToPort.value = "";
		document.ipportFilter.sFromPort.value = "";
		document.ipportFilter.sToPort.value = "";
	}
}

function initTranslation()
{

	var e; // = document.getElementById("portTitle"); 
	//e.innerHTML = Get_string("port title");
	
	//tab-page
	//e = document.getElementById("firewallTitlePortFilter");
	//e.innerHTML = Get_string("firewall Title PortFilter");
	//e = document.getElementById("firewallTitlePortForward");
	//e.innerHTML = Get_string("firewall Title PortForward");
	//e = document.getElementById("firewallTitleSys");
	//e.innerHTML = Get_string("firewall Title Sys");
	

	e = document.getElementById("portBasicSet");
	e.innerHTML = Get_string("port basic settings");
	e = document.getElementById("portBasicFilter");
	e.innerHTML = Get_string("port basic filter");
	e = document.getElementById("portBasicDisable");
	e.innerHTML = Get_string("firewall disable");
	e = document.getElementById("portBasicEnable");
	e.innerHTML = Get_string("firewall enable");
	e = document.getElementById("portBasicDefaultPolicy");
	e.innerHTML = Get_string("port basic default policy");
	
	e = document.getElementById("portBasicDefaultPolicyAccept");
	e.innerHTML = Get_string("port basic default policy accepted");
	e = document.getElementById("portBasicDefaultPolicyDrop");
	e.innerHTML = Get_string("port basic default policy dropped");
	e = document.getElementById("portBasicApply");
	e.value = Get_string("firewall apply");

	e = document.getElementById("portFilterSet");
	e.innerHTML = Get_string("port filter setting");
	e = document.getElementById("portFilterMac");
	e.innerHTML = Get_string("port filter macaddr");
	e = document.getElementById("portFilterSIPAddr");
	e.innerHTML = Get_string("port filter source ipaddr");
	e = document.getElementById("portFilterSPortRange");
	e.innerHTML = Get_string("port filter source port range");
	e = document.getElementById("portFilterDIPAddr");
	e.innerHTML = Get_string("port filter dest ipaddr");
	e = document.getElementById("portFilterDPortRange");
	e.innerHTML = Get_string("port filter dest port range");
	e = document.getElementById("portFilterProtocol");
	e.innerHTML = Get_string("firewall protocol");
	e = document.getElementById("portFilterAction");
	e.innerHTML = Get_string("port filter action");
	e = document.getElementById("portFilterActionDrop");
	e.innerHTML = Get_string("port filter action drop");
	e = document.getElementById("portFilterActionAccept");
	e.innerHTML = Get_string("port filter action accept");
	e = document.getElementById("portFilterComment");
	e.innerHTML = Get_string("firewall comment");
	e = document.getElementById("portFilterApply");
	e.value = Get_string("firewall apply");
	e = document.getElementById("portFilterReset");
	e.value = Get_string("firewall reset");

	e = document.getElementById("portCurrentFilter");
	e.innerHTML = Get_string("port current filter");
	e = document.getElementById("portCurrentFilterNo");
	e.innerHTML = Get_string("firewall no");
	e = document.getElementById("portCurrentFilterSIP");
	e.innerHTML = Get_string("port filter source ipaddr");
	e = document.getElementById("portCurrentFilterSPort");
	e.innerHTML = Get_string("port filter source port range");
	e = document.getElementById("portCurrentFilterDIP");
	e.innerHTML = Get_string("port filter dest ipaddr");
	e = document.getElementById("portCurrentFilterMac");
	e.innerHTML = Get_string("port filter macaddr");
	e = document.getElementById("portCurrentFilterDPort");
	e.innerHTML = Get_string("port filter dest port range");
	e = document.getElementById("portCurrentFilterProtocol");
	e.innerHTML = Get_string("firewall protocol");
	e = document.getElementById("portCurrentFilterAction");
	e.innerHTML = Get_string("port filter action");
	e = document.getElementById("portCurrentFilterComment");
	e.innerHTML = Get_string("firewall comment");
	e = document.getElementById("portCurrentFilterDel");
	e.value = Get_string("firewall del select");
	e = document.getElementById("portCurrentFilterReset");
	e.value = Get_string("firewall reset");

	e = document.getElementById("example_MAC");
	e.innerHTML = Get_string("example MAC");
	e = document.getElementById("example_IP");
	e.innerHTML = Get_string("example IP");
	e = document.getElementById("maximum_desc");
	e.innerHTML = Get_string("maximum desc");
	
	
	e = document.getElementById("procotol_none");
	e.innerHTML = Get_string("procotol_none");
	

	initRuleListTranslation();
}

function initRuleListTranslation()
{
	var e;
	
	if(document.getElementById("portCurrentFilterDefaultDrop"))
	{
		e = document.getElementById("portCurrentFilterDefaultDrop");
		e.innerHTML = Get_string("firewall default drop");
	}
	if(document.getElementById("portCurrentFilterDefaultAccept"))
	{
		e = document.getElementById("portCurrentFilterDefaultAccept");
		e.className = 'warningInfo';
		e.innerHTML = Get_string("firewall default accept");
	}

	var i=0;
	while( document.getElementById("portFilterActionDrop"+i) ||
			document.getElementById("portFilterActionAccept"+i) )
	{
		if(document.getElementById("portFilterActionDrop"+i))
		{
			e = document.getElementById("portFilterActionDrop"+i);
			e.innerHTML = Get_string("port filter action drop");
		}

		if(document.getElementById("portFilterActionAccept"+i))
		{
			e = document.getElementById("portFilterActionAccept"+i);
			e.innerHTML = Get_string("port filter action accept");
		}

		i++;
	}
}

/*
function initValue()
{
	document.BasicSettings.portFilterEnabled.options.selectedIndex = parseInt(ip_port_filter_enable);
	document.BasicSettings.defaultFirewallPolicy.options.selectedIndex = parseInt(default_policy);	
}
*/

function updateState()
{
    if( !rules_num )
	{
 		disableTextField(document.ipportFilterDelete.deleteSelFilterPort);
 		disableTextField(document.ipportFilterDelete.reset);
	}
	else
	{
        enableTextField(document.ipportFilterDelete.deleteSelFilterPort);
        enableTextField(document.ipportFilterDelete.reset);
	}
	
	if( document.BasicSettings.defaultFirewallPolicy.options.selectedIndex == 0)
	{
		document.ipportFilter.action.options.selectedIndex = 0;
	}
	else
	{
		document.ipportFilter.action.options.selectedIndex = 1;
	}

	protocolChange();

	if( document.BasicSettings.portFilterEnabled.options.selectedIndex == 1)
	{
		document.ipportFilter.style.display="";
		document.ipportFilterDelete.style.display="";
		document.getElementById("tmp1").style.display="";
	}
	else
	{
		document.ipportFilter.style.display="none";
		document.ipportFilterDelete.style.display="none";
		document.getElementById("tmp1").style.display="none";		
	}
}
function deletOK(){
	document.ipportFilterDelete.submit();
}
function initPage()
{
	initTranslation();
	//initValue();
	updateState();
}

</script>
</head>

<body  style="background-color:; overflow-x:;" onLoad="initPage();" >
	<!-- ================= showerror div begin================= -->
	<div id="MsgLayer1" onClick="setinner('hidden')">	</div>
	<div id="MsgLayer2" onClick="setinner('hidden')">
		<div id="errLayer">
			<table height="48" width="320" border="0" >
				<tr>
					<td width="320" align="center"><span class="msg" id="errmsg" name="errmsg">
					</span></td>
				</tr>
			</table>
		</div>
	</div>
	<iframe id="ifr" name="ifr" src="about:blank"></iframe>
	<!-- ================= showerror div end================= -->
	<!-- ================= toptip div begin================= -->
	<div id="overDiv"></div>
	<!-- ================= toptip div end================= -->

<table cellspacing="0" cellpadding="0" border="0" class="body_table">
	<tr>
	<td valign="top">
    <!-- ====================   BASIC  form  ==================== -->
    <form method="post" name="BasicSettings" action="/goform/goform_process" onSubmit="return formCheck()">
    <INPUT type="hidden" value="FW_BASIC" name="goformId" id="goformId">
    <INPUT type="hidden" value="" name="lucknum_FW_BASIC" id="lucknum_FW_BASIC"> 	
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
    <tr>
        <td class="labelfont" colspan="2" id="portBasicSet">Basic Settings</td>
    </tr>
    
    <tr>
        <td class="top_head" id="portBasicFilter"  width="50%">
            MAC/IP/Port Filtering
        </td>
        <td class="tail" width="50%">
        <select onChange="updateState()" name="portFilterEnabled" id="portFilterEnabled">
        <option id="portBasicDisable" value=0 <% getIPPortFilterEnableASP(0); %>>Disable</option>
        <option id="portBasicEnable" value=1 <% getIPPortFilterEnableASP(1); %>>Enable</option>
        </select>
        </td>
    </tr>
    </table>
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
    <tr name = "tmp1" id="tmp1">
        <td class="top_head" id="portBasicDefaultPolicy" width="50%">
            Default Policy -- The packet that doesn't match with any rules would be:
        </td>
        <td class="tail" width="50%">
            <select onChange="defaultPolicyChanged()" name="defaultFirewallPolicy">
            <option id="portBasicDefaultPolicyAccept" value=0 <% getDefaultFirewallPolicyASP(0); %>>Accepted</option>
            <option id="portBasicDefaultPolicyDrop" value=1 <% getDefaultFirewallPolicyASP(1); %>>Dropped</option>
            </select>
        </td>
    </tr>
    </table>
     <br>                                                                             
        <input class="btn" type="submit" value="Apply" id="portBasicApply" name="portBasicApply" onMouseOver="this.className='menu_over'" onMouseOut="this.className='menu_out'" onMouseDown="this.className='menu_down'">
 
    
    </form>

    <!-- ====================   MAC/IP/Port form   ==================== -->
    <form method=post name="ipportFilter" action="/goform/goform_process" onSubmit="return ipportFormCheck()" autocomplete="off">
    <INPUT type="hidden" value="FW_FILTER_ADD" name="goformId" id="goformId">
    <INPUT type="hidden" value="" name="lucknum_FW_FILTER_ADD" id="lucknum_FW_FILTER_ADD">
    
    <table cellSpacing=0 cellPadding=10 width="100%" border=0>
    <tr>
        <td class="labelfont" colspan="4" id="portFilterSet">IP/Port Filter Settings</td>
    </tr>
    
    <tr>
        <td class="top_head" colspan="2" id="portFilterMac" width="25%">
            Mac address
        </td>
        <td colspan="2" class="tail" >
             <input id="mac_address" name="mac_address" type="text" size="18" > 
             <span id="example_MAC">&nbsp;(XX:XX:XX:XX:XX:XX,&nbsp;&nbsp;eg:&nbsp;00:1E:90:FF:FF:FF)</span>	</td>
    </tr>
    
    <tr>
        <td class="top_head" colspan="2" id="portFilterDIPAddr">
            Dest. IP Address
        </td>
        <td colspan="2" class="tail">
            <input type="text" size="16" name="dip_address" id="dip_address">
            <span id="example_IP">&nbsp;( XXX.XXX.XXX.XXX, eg: 192.168.5.101)</span>
            <!-- we dont support ip range in kernel 2.4.30 
            -<input type="text" size="16" name="dip_address2">
            -->	</td>
    </tr>
    
    <tr>
        <td class="top_head" colspan="2" id="portFilterSIPAddr">
            Src. IP Address
        </td>
        <td colspan="2" class="tail">
            <input type="text" size="16" name="sip_address" id="sip_address">
            <!-- we dont support ip range in kernel 2.4.30 
            -<input type="text" size="16" name="sip_address2">
            -->
        </td>
    </tr>
    
    <tr>
        <td class="top_head" colspan="2" id="portFilterProtocol">
            Protocol
        </td>
        <td colspan="2" class="tail">
            <select onChange="protocolChange()" name="protocol" id="procotol">
            <option value="None" id="procotol_none">None</option>
            <option value="TCP">TCP</option>
            <option value="UDP">UDP</option>
            <!--<option value="TCP&UDP">TCP+UDP</option>-->
            <option value="ICMP">ICMP</option>
            </select>&nbsp;&nbsp;
        </td>
    </tr>
    
    <tr>
        <td class="top_head" colspan="2" id="portFilterDPortRange">
            Dest. Port Range
        </td>
        <td colspan="2"  class="tail">
            <input type="text" size="5" name="dFromPort" id="dFromPort">-
            <input type="text" size="5" name="dToPort" id="dToPort">&nbsp;( 1~65535)
        </td>
    </tr>
    
    
    <tr>
        <td class="top_head" colspan="2" id="portFilterSPortRange">
            Src. Port Range
        </td>
        <td colspan="2" class="tail">
            <input type="text" size="5" name="sFromPort" id="sFromPort">-
            <input type="text" size="5" name="sToPort" id="sToPort">&nbsp;( 1~65535)
        </td>
    </tr>
    
    <tr>
        <td class="top_head" colspan="2" id="portFilterAction">
            Action
        </td>
        <td colspan="2" class="tail">
            <select name="action">
            <option value="Drop" id="portFilterActionDrop">Drop</option>
            <option value="Accept" id="portFilterActionAccept">Accept</option>
            </select>
        </td>
    </tr>
    
    <tr>
        <td class="top_head" colspan="2" id="portFilterComment">
            Comment
        </td>
        <td colspan="2" class="tail">
            <input type="text" name="comment" id="comment" size="16" maxlength="32">
        </td>
    </tr>
    </table>
	<span id="maximum_desc" class='warningInfo' style="padding-left:15px;">The maximum rule count is 10.</span>
      <br>
      <input class="btn" type="submit" value="Apply" id="portFilterApply" name="portFilterApply" onMouseOver="this.className='menu_over'" onMouseOut="this.className='menu_out'" onMouseDown="this.className='menu_down'">
        <input class="btn" type="reset" value="Reset" id="portFilterReset" name="reset" onClick="resetItems()" onMouseOver="this.className='menu_over'" onMouseOut="this.className='menu_out'" onMouseDown="this.className='menu_down'">
  
    
    </form>

    <!-- =========================  delete rules  ========================= -->
    <form action="/goform/goform_process" method="post" name="ipportFilterDelete">
    <INPUT type="hidden" value="FW_FILTER_DEL" name="goformId" id="goformId">
    <INPUT type="hidden" value="" name="lucknum_FW_FILTER_DEL" id="lucknum_FW_FILTER_DEL">
    <table cellSpacing=0 cellPadding=10 width="100%" border=0>
        <tr>
            <td class="labelfont" colspan="10" id="portCurrentFilter">Current MAC/IP/Port Filtering Rules in System: </td>
        </tr>
    
        <tr>
            <td align="center" id="portCurrentFilterNo" class="title_tail" style="width:60px;" nowrap> No.</td>
            <td align="center" id="portCurrentFilterMac" class="title_tail" nowrap> MAC Address </td>
            <td align="center" id="portCurrentFilterDIP" class="title_tail" nowrap> Dest. IP Address </td>
            <td align="center" id="portCurrentFilterSIP" class="title_tail" nowrap> Src. IP Address </td>
            <td align="center" id="portCurrentFilterProtocol" class="title_tail" nowrap> Protocol</td>
            <td align="center" id="portCurrentFilterDPort" class="title_tail" nowrap> Dest. Port Range</td>
            <td align="center" id="portCurrentFilterSPort" class="title_tail" nowrap> Src. Port Range</td>
            <td align="center" id="portCurrentFilterAction" class="title_tail" nowrap> Action</td>
            <td align="center" id="portCurrentFilterComment" class="title_tail" nowrap> Comment</td>
        </tr>
        <% showIPPortFilterRulesASP(); %>
    </table>
    <br>
    <input class="btn" type="button" value="Delete" id="portCurrentFilterDel" name="deleteSelFilterPort" onClick=" deleteClick('lucknum_FW_FILTER_DEL')"onMouseOver="this.className='menu_over'" onMouseOut="this.className='menu_out'" onMouseDown="this.className='menu_down'">
    <input class="btn" type="reset" value="Reset" id="portCurrentFilterReset" name="reset" onMouseOver="this.className='menu_over'" onMouseOut="this.className='menu_out'" onMouseDown="this.className='menu_down'"> 
    </form>

    </td>
    </tr>
</table>
<div id="alert_string" style="display:none;"></div>
</body>
</html>
