/**
 * 短信参数设置
 * @module sms_setting
 * @class sms_setting
 */
define([ 'underscore', 'jquery', 'knockout', 'config/config', 'service' ],
    function(_, $, ko, config, service) {

        var validityModes = _.map(config.SMS_VALIDITY, function(item) {
            return new Option(item.name, item.value);
        });

        function SmsSettingVM() {
            var self = this;
            var setting = getSmsSetting();
            var info = service.getStatusInfo();
            self.modes = ko.observableArray(validityModes);
            self.selectedMode = ko.observable(setting.validity);
            self.centerNumber = ko.observable(setting.centerNumber);
            self.deliveryReport = ko.observable(setting.deliveryReport);
            self.isDeleteSMS = ko.observable(info.sms_auto_delete);//是否短信满的时候删除1，是；0，不是；
            self.setSMSDelete = function() {
                if(!$("#deleteFullSMS").hasClass("disable")){
                    var checkbox = $("#isDeleteSMS:checked");
                    if(checkbox && checkbox.length == 0 ){
                        self.isDeleteSMS("1");
                    }else{
                        self.isDeleteSMS("0");
                    }
                }
            };

            self.clear = function() {
                init();
                clearValidateMsg();
            };

            self.save = function() {
                showLoading();
                var params = {};
                params.validity = self.selectedMode();
                params.centerNumber = self.centerNumber();
                params.deliveryReport = self.deliveryReport();
                params.sms_auto_delete = self.isDeleteSMS();
                service.setSmsSetting(params, function(result) {
                    if (result.result == "success") {
                        successOverlay();
                    } else {
                        errorOverlay();
                    }
                });
            };

        }

        /**
         * 获取短信设置参数
         * @method getSmsSetting
         * @return {Object}
         */
        function getSmsSetting() {
            return service.getSmsSetting();
        }

        function init() {
            var container = $('#container');
            ko.cleanNode(container[0]);
            var vm = new SmsSettingVM();
            ko.applyBindings(vm, container[0]);
            $('#smsSettingForm').validate({
                submitHandler : function() {
                    vm.save();
                },
                rules: {
                    txtCenterNumber: "sms_service_center_check"
                }
            });
        }

        return {
            init : init
        };
    }
);
