/**
 * @module display ssid setting
 * @class dispaly ssid setting
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore' ],

    function($, ko, config, service, _) {

        /**
         * system display ssid setting VM
         * @class DisplaySSIDSettingVM
         */
        function DisplaySSIDSettingVM() {
            var self = this;
            var info = service.getDisplaySSID();

            self.display_ssid_enable = ko.observable(info.wifikey_display_enable);

            self.save = function() {
                showLoading();
                var params = {};
                params.wifikey_display_enable = self.display_ssid_enable();
                service.setDisplaySSID(params, function(result) {
                    if (result.result == "success") {
                        successOverlay();
                    } else {
                        errorOverlay();
                    }
                });

            };
        }

        function init() {
            var container = $('#display_ssid');
            ko.cleanNode(container[0]);
            var vm = new DisplaySSIDSettingVM();
            ko.applyBindings(vm, container[0]);
            $('#frmDisplaySSID').validate({
                submitHandler : function() {
                    vm.save();
                }
            });
        }

        return {
            init : init
        };
    });