﻿/**
 * network_lock 模块
 * @module network_lock
 * @class network_lock
 */
define(['knockout', 'service', 'jquery', 'config/config', 'home'], function (ko, service, $, config, home) {

    function lockVM() {
        var self = this;
        self.deviceInfo = ko.observable([]);
        self.hasWifi = ko.observable(config.HAS_WIFI);
        var infoFlux = service.getTrafficAlertInfo();
        var info2 = service.getTrafficAlertInfo();
        var dataMonth = info2.limitDataMonth.split("_");
        self.selectedDataUnit = ko.observable(dataMonth[1]);
        var totalFluxUnit;
        if(self.selectedDataUnit() == "1"){
            totalFluxUnit = "MB";
        } else if(self.selectedDataUnit() == "1024") {
            totalFluxUnit = "GB";
        } else {
            totalFluxUnit = "TB";
        }
        self.limitDataMonth = ko.observable(dataMonth[0]);
        self.isFluxAlertOpen = ko.observable(infoFlux.dataLimitChecked == '0' ? false : true);
        self.used_total_flux = ko.observable("0"+ totalFluxUnit + "/" + self.limitDataMonth() + totalFluxUnit);
        self.supportUnlock = config.NETWORK_UNLOCK_SUPPORT;
        self.unlockCode = ko.observable();

        var info = service.getNetworkUnlockTimes();
        self.times = ko.observable(info.unlock_nck_time);

        self.imagePath = ko.observable("img/disconnect.png");
        self.isHomePage = ko.observable(false);
        if (window.location.hash == "#home") {
            self.isHomePage(true);
        }
        self.supportQrCode = ko.observable(config.WIFI_SUPPORT_QR_CODE);
        self.qrcode_ssid1 = ko.observable(getRQCodeImage(true));

        function getRQCodeImage(isSSID1) {
            if (self.supportQrCode()) {
                var timestamp = new Date().getTime();
                if (isSSID1) {
                    return './img/qrcode_ssid_wifikey.png?_=' + timestamp;
                } else if (config.HAS_MULTI_SSID) {
                    return './img/qrcode_multi_ssid_wifikey.png?_=' + timestamp;
                } else {
                    return './img/menu_normal1.png';
                }
            } else {
                return './img/menu_normal1.png';
            }
        }

        self.unlock = function () {
            showLoading();
            service.unlockNetwork({
                unlock_network_code:self.unlockCode()
            }, function (data) {
                self.unlockCode("");
                if (data && data.result == "success") {
                    successOverlay();
                    if (window.location.hash == "#home") {
                        setTimeout(function () {
                            window.location.reload();
                        }, 500);
                    } else {
                        window.location.hash = "#home";
                    }
                } else {
                    var info = service.getNetworkUnlockTimes();
                    self.times(info.unlock_nck_time);
                    errorOverlay();
                }
            })
        }
    }

    function init() {
        var container = $('#container')[0];
        ko.cleanNode(container);
        var vm = new lockVM();
        ko.applyBindings(vm, container);

        $("#frmNetworkLock").validate({
            submitHandler:function () {
                vm.unlock();
            },
            rules:{
                txtLockNumber:"unlock_code_check"
            }
        });

        if (vm.hasWifi()) {
            home.refreshAttachedDevicesInfo(vm);
            addInterval(function () {
                home.refreshAttachedDevicesInfo(vm);
            }, 1000);
        }
    }

    return {
        init:init
    };
});