/**
 * @module wifi basic
 * @class wifi basic
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore' ],

    function ($, ko, config, service, _) {

        var securityModes = _.map(config.AUTH_MODES, function (item) {
            return new Option(item.name, item.value);
        });

        function maxStationOption(max) {
            var options = [];
            for (var i = 1; i <= max; i++) {
                options.push(new Option(i, i));
            }
            return options;
        }

        /**
         * wifi basic view model
         * @class WifiBasicVM
         */
        function WifiBasicVM() {
            var self = this;
            var info = getWifiBasic();
            self.hasMultiSSID = config.HAS_MULTI_SSID;
	        //*Special* Just for MF70
	        self.hasWifiSwitch = config.WIFI_SWITCH_SUPPORT;
	        self.wifi_enable = ko.observable(info.wifi_enable);
            self.multi_ssid_enable = ko.observable(info.multi_ssid_enable);
            self.origin_multi_ssid_enable = info.multi_ssid_enable;
            self.supportQrCode = ko.observable(config.WIFI_SUPPORT_QR_CODE);
            self.apStationSupport = config.AP_STATION_SUPPORT;

            self.maxStationNumber = ko.computed(function () {
                return config.MAX_STATION_NUMBER;
//            if (self.hasMultiSSID && self.origin_multi_ssid_enable == "1") {
//                return config.MAX_STATION_NUMBER - 1;
//            } else {
//                return config.MAX_STATION_NUMBER;
//            }
            });

            self.modes = ko.observableArray(securityModes);
            self.selectedMode = ko.observable(info.AuthMode);
            self.encryptType = ko.observable(info.encryptType);
			self.m_encryptType = ko.observable(info.m_encryptType);
			self.keyID = ko.observable(info.DefaultKeyID);
			self.m_keyID = ko.observable(info.m_DefaultKeyID);			
			self.password  = ko.observable("");

            self.popupNoneModeNote = function (){
                if(self.selectedMode() == "OPEN" && self.encryptType() == "NONE"){
                    showAlert("choose_none");
                }
            }

			if(self.keyID() =='0'){
				self.password(info.Key1Str1);
			}else if(self.keyID() =='1'){
				self.password(info.Key2Str1);
			}else if(self.keyID() =='2'){
				self.password(info.Key3Str1);
			}else if(self.keyID() =='3'){
				self.password(info.Key4Str1);
			}else{
				self.password(info.Key1Str1);
			}	
			self.m_password  = ko.observable("");
			if(self.m_keyID() =='0'){
				self.m_password(info.m_Key1Str1);
			}else if(self.m_keyID() =='1'){
				self.m_password(info.m_Key2Str1);
			}else if(self.m_keyID() =='2'){
				self.m_password(info.m_Key3Str1);
			}else if(self.m_keyID() =='3'){
				self.m_password(info.m_Key4Str1);
			}else{
				self.m_password(info.m_Key1Str1);
			}				
            self.passPhrase = ko.observable(info.passPhrase);
            self.showPassword = ko.observable(false);
            self.showPassword_wep = ko.observable(false);		
            self.m_showPassword_wep = ko.observable(false);				
            self.ssid = ko.observable(info.SSID);
            self.broadcast = ko.observable(info.broadcast == '1' ? '1' : '0');
            self.cipher = info.cipher;
            self.selectedStation = ko.observable(info.MAX_Access_num);
            self.maxStations = ko.observableArray(maxStationOption(info.MAX_Station_num));

            self.m_modes = ko.observableArray(securityModes);
            self.m_selectedMode = ko.observable(info.m_AuthMode);
            self.m_passPhrase = ko.observable(info.m_passPhrase);
            self.m_showPassword = ko.observable(false);
            self.m_ssid = ko.observable(info.m_SSID);
            self.m_broadcast = ko.observable(info.m_broadcast == '1' ? '1' : '0');
            self.m_cipher = info.m_cipher;
            self.m_selectedStation = ko.observable(info.m_MAX_Access_num);
            self.m_maxStations = ko.observableArray(maxStationOption(info.MAX_Station_num));
            self.qrcode_ssid1 = ko.observable(getRQCodeImage(true));
            self.qrcode_ssid2 = ko.observable(getRQCodeImage(false));
			self.showQrCode = ko.observable(true);
			self.m_showQrCode = ko.observable(true);

            self.setBroadcast = function(){
                if(!$("#broadcastP").hasClass("disable")){
                    var checkbox = $("#broadcastEnable:checked");
                    if(checkbox && checkbox.length == 0 ){
                        self.broadcast("0");
                    }else{
                        self.broadcast("1");
                        showAlertSpe("close_broadcast_note_title","close_broadcast_note");
                    }
                }
            }

            self.checkPassword = function (){
                if(self.selectedMode() == "WPA2PSK" ||  self.selectedMode() == "WPAPSKWPA2PSK"){
                    if(self.passPhrase() == "" || self.passPhrase().length <8){
                        return false;
                    } else {
                        return true;
                    }
                } else{
                    return true;
                }
            }

            self.profileChangeHandler = function(data, event) {
			        $("#pwdWepKey").parent().find(".error").hide();		
					if(self.keyID() =='0'){
						self.password(info.Key1Str1);
					}else if(self.keyID() =='1'){
						self.password(info.Key2Str1);
					}else if(self.keyID() =='2'){
						self.password(info.Key3Str1);
					}else if(self.keyID() =='3'){
						self.password(info.Key4Str1);
					}else{
						self.password(info.Key1Str1);
					}
			return true;
		};			
			self.m_profileChangeHandler = function(data, event) {
			        $("#m_pwdWepKey").parent().find(".error").hide();					
					if(self.m_keyID() =='0'){
						self.m_password(info.m_Key1Str1);
					}else if(self.m_keyID() =='1'){
						self.m_password(info.m_Key2Str1);
					}else if(self.m_keyID() =='2'){
						self.m_password(info.m_Key3Str1);
					}else if(self.m_keyID() =='3'){
						self.m_password(info.m_Key4Str1);
					}else{
						self.m_password(info.m_Key1Str1);
					}
			return true;
		};
            self.clear = function (option) {
                if (option == "switch") {
                    self.multi_ssid_enable(info.multi_ssid_enable);
                } else if (option == "ssid1") {
                    self.selectedMode(info.AuthMode);
                    self.encryptType(info.encryptType);	
					self.keyID(info.DefaultKeyID);	
					if(self.keyID() =='0'){
						self.password = ko.observable(info.Key1Str1);
					}else if(self.keyID() =='1'){
						self.password = ko.observable(info.Key2Str1);
					}else if(self.keyID() =='2'){
						self.password = ko.observable(info.Key3Str1);
					}else if(self.keyID() =='3'){
						self.password = ko.observable(info.Key4Str1);
					}else{
						self.password = ko.observable(info.Key1Str1);
					}					
                    self.passPhrase(info.passPhrase);
                    self.ssid(info.SSID);
                    self.broadcast(info.broadcast == '1' ? '1' : '0');
                    self.cipher = info.cipher;
                    self.selectedStation(info.MAX_Access_num);
                } else if (option == "ssid2") {
                    self.m_selectedMode(info.m_AuthMode);
					self.m_encryptType(info.m_encryptType);	
                    self.m_passPhrase(info.m_passPhrase);
                    self.m_ssid(info.m_SSID);
                    self.m_broadcast(info.m_broadcast == '1' ? '1' : '0');
                    self.m_cipher = info.m_cipher;
                    self.m_selectedStation(info.m_MAX_Access_num);
		    self.m_keyID(info.m_DefaultKeyID);	
					if(self.m_keyID() =='0'){
						self.m_password = ko.observable(info.m_Key1Str1);
					}else if(self.m_keyID() =='1'){
						self.m_password = ko.observable(info.m_Key2Str1);
					}else if(self.m_keyID() =='2'){
						self.m_password = ko.observable(info.m_Key3Str1);
					}else if(self.m_keyID() =='3'){
						self.m_password = ko.observable(info.m_Key4Str1);
					}else{
						self.m_password = ko.observable(info.m_Key1Str1);
					}
                }else if(option == "wifiswitch"){
		    //*Special* Just for MF70
                    self.wifi_enable(info.wifi_enable);
                } else {
                    clearTimer();
                    clearValidateMsg();
                    init();
                }
            };

            /**
             * 检测wps是否开启，最大接入数是否超过最大值。
             *
             * @event checkSettings
             */
            self.checkSettings = function (ssid) {
                var status = getWpsInfo();
                if (status.radioFlag == "0") {
                    showAlert('wps_wifi_off');
                    return true;
                }
                if (status.wpsFlag == '1') {
                    showAlert('wps_on_info');
                    return true;
                }
                if (config.HAS_MULTI_SSID && info.multi_ssid_enable == "1") {
                    if ((ssid == "ssid1" && parseInt(self.selectedStation()) + parseInt(info.m_MAX_Access_num) > info.MAX_Station_num)
                        || (ssid == "ssid2" && parseInt(self.m_selectedStation()) + parseInt(info.MAX_Access_num) > info.MAX_Station_num)) {
                        showAlert({msg:'multi_ssid_max_access_number_alert', params: info.MAX_Station_num});
                        return true;
                    }
                }
                if (ssid == "switch") {
                    var result = service.getStatusInfo();
                    if (result.connectWifiSSID && (result.connectWifiStatus == "connecting" || result.connectWifiStatus == "connect")) {
                        showAlert('cannot_operate_when_wifi_connected');
                        return true;
                    }
                }
                return false;
            };

            self.saveSSID1 = function () {
                if (self.checkSettings("ssid1")) {
                    return;
                }
                if(((self.selectedMode() == "OPEN" && self.encryptType() == "WEP")||self.selectedMode() == "SHARED") && service.getWifiAdvance().mode == "2") {
                    showAlert("n_only_cannot_open_wep");
                    return;
                }
                showConfirm('wifi_disconnect_confirm', function(){
                    self.saveSSID1Action();
                });
            };
            /**
             * 保存SSID1的设置
             *
             * @event saveSSID1
             */
            self.saveSSID1Action = function () {
                showLoading();
                var params = {};
                params.AuthMode = self.selectedMode();
                params.encryptType = self.encryptType();
				params.wep_default_key = self.keyID();
				if(self.keyID() =='0'){
					params.wep_key_1 = self.password();
					params.wep_key_2 = info.Key2Str1;
					params.wep_key_3 = info.Key3Str1;
					params.wep_key_4 = info.Key4Str1;
					if(self.password().length =='5' ||self.password().length =='13'){
					params.WEP1Select = '1';	
					}else{
					params.WEP1Select = '0';	
					}
				}else if(self.keyID() =='1'){
					params.wep_key_1 = info.Key1Str1;	
					params.wep_key_2 = self.password();
					params.wep_key_3 = info.Key3Str1;
					params.wep_key_4 = info.Key4Str1;
					if(self.password().length =='5' ||self.password().length =='13'){
					params.WEP2Select = '1';	
					}else{
					params.WEP2Select = '0';	
					}					
				}else if(self.keyID() =='2'){
					params.wep_key_1 = info.Key1Str1;	
					params.wep_key_2 = info.Key2Str1;					
					params.wep_key_3 = self.password();
					params.wep_key_4 = info.Key4Str1;
					if(self.password().length =='5' ||self.password().length =='13'){
					params.WEP3Select = '1';	
					}else{
					params.WEP3Select = '0';	
					}						
				}else if(self.keyID() =='3'){
					params.wep_key_1 = info.Key1Str1;	
					params.wep_key_2 = info.Key2Str1;
					params.wep_key_3 = info.Key3Str1;
					params.wep_key_4 = self.password();
					if(self.password().length =='5' ||self.password().length =='13'){
					params.WEP4Select = '1';	
					}else{
					params.WEP4Select = '0';	
					}						
				}else{
					params.wep_key_1 = self.password();
					params.wep_key_2 = info.Key2Str1;
					params.wep_key_3 = info.Key3Str1;
					params.wep_key_4 = info.Key4Str1;					
					if(self.password().length =='5' ||self.password().length =='13'){
					params.WEP1Select = '1';	
					}else{
					params.WEP1Select = '0';	
					}					
				}
			//	params.password = self.password();	
                params.passPhrase = self.passPhrase();
                params.SSID = self.ssid();
                params.broadcast = self.broadcast();
                params.station = self.selectedStation();
                if(self.selectedMode() == 'WPA2PSK'){
                    params.cipher =  '2';
                } else {
                params.cipher = self.cipher;
                }
                service.setWifiBasic(params, function (result) {
                    if (result.result == "success") {
                        successOverlay();
                        self.clear();
                    } else {
                        errorOverlay();
                    }
                    self.qrcode_ssid1(getRQCodeImage(true));
                });
            };

            self.saveSSID2 = function () {
                if (self.checkSettings("ssid2")) {
                    return;
                }
                showConfirm('wifi_disconnect_confirm', function(){
                    self.saveSSID2Action();
                });
            };
            /**
             * 保存SSID2的设置
             *
             * @event saveSSID2
             */
            self.saveSSID2Action = function () {
                showLoading();
                var params = {};
                params.m_AuthMode = self.m_selectedMode();
				params.m_encryptType = self.m_encryptType();
				params.m_DefaultKeyID = self.m_keyID();
				if(self.m_keyID() =='0'){
					params.m_Key1Str1 = self.m_password();
					params.m_Key2Str1 = info.m_Key2Str1;
					params.m_Key3Str1 = info.m_Key3Str1;
					params.m_Key4Str1 = info.m_Key4Str1;
					if(self.m_password().length =='5' ||self.m_password().length =='13'){
					params.m_Key1Type = '1';	
					}else{
					params.m_Key1Type = '0';	
					}
				}else if(self.m_keyID() =='1'){
					params.m_Key1Str1 = info.m_Key1Str1;	
					params.m_Key2Str1 = self.m_password();
					params.m_Key3Str1 = info.m_Key3Str1;
					params.m_Key4Str1 = info.m_Key4Str1;
					if(self.m_password().length =='5' ||self.m_password().length =='13'){
					params.m_Key2Type = '1';	
					}else{
					params.m_Key2Type = '0';	
					}					
				}else if(self.m_keyID() =='2'){
					params.m_Key1Str1 = info.m_Key1Str1;	
					params.m_Key2Str1 = info.m_Key2Str1;					
					params.m_Key3Str1 = self.m_password();
					params.m_Key4Str1 = info.m_Key4Str1;
					if(self.m_password().length =='5' ||self.m_password().length =='13'){
					params.m_Key3Type = '1';	
					}else{
					params.m_Key3Type = '0';	
					}						
				}else if(self.m_keyID() =='3'){
					params.m_Key1Str1 = info.m_Key1Str1;	
					params.m_Key2Str1 = info.m_Key2Str1;
					params.m_Key3Str1 = info.m_Key3Str1;
					params.m_Key4Str1 = self.m_password();
					if(self.m_password().length =='5' ||self.m_password().length =='13'){
					params.m_Key4Type = '1';	
					}else{
					params.m_Key4Type = '0';	
					}						
				}else{
					params.m_Key1Str1 = self.m_password();
					params.m_Key2Str1 = info.m_Key2Str1;
					params.m_Key3Str1 = info.m_Key3Str1;
					params.m_Key4Str1 = info.m_Key4Str1;					
					if(self.m_password().length =='5' ||self.m_password().length =='13'){
					params.m_Key1Type = '1';	
					}else{
					params.m_Key1Type = '0';	
					}					
				}				
                params.m_passPhrase = self.m_passPhrase();
                params.m_SSID = self.m_ssid();
                params.m_broadcast = self.m_broadcast();
                params.m_station = self.m_selectedStation();
                params.m_cipher = self.m_cipher;
                service.setWifiBasic4SSID2(params, function (result) {
                    if (result.result == "success") {
                        successOverlay();
                        self.clear();
                    } else {
                        errorOverlay();
                    }
                    self.qrcode_ssid2(getRQCodeImage(false));
                });
            };

            /**
             * 设置多SSID开关
             *
             * @event setMultiSSIDSwitch
             */
            self.setMultiSSIDSwitch = function () {
                if (self.checkSettings("switch")) {
                    return;
                }

                var setSwitch = function () {
                    showLoading();
                    var params = {};
                    params.multi_ssid_enable = self.multi_ssid_enable();
                    service.setWifiBasicMultiSSIDSwitch(params, function (result) {
                        if (result.result == "success") {
                            successOverlay();
                            self.clear();
                        } else {
                            errorOverlay();
                        }
                        self.qrcode_ssid1(getRQCodeImage(true));
                        self.qrcode_ssid2(getRQCodeImage(false));
                    });
                };

                if (self.multi_ssid_enable() == "1") {
                    if (config.AP_STATION_SUPPORT) {
                        showConfirm("multi_ssid_enable_confirm", function () {
                            setSwitch();
                        })
                    } else {
                        setSwitch();
                    }
                } else {
                    setSwitch();
                }
            };

            /**
             * SSID1密码显示事件
             *
             * @event showPasswordHandler
             */
            self.showPasswordHandler = function () {
                $("#passShow").parent().find(".error").hide();
                var checkbox = $("#showPassword:checked");
                if (checkbox && checkbox.length == 0) {
                    self.showPassword(true);
                } else {
                    self.showPassword(false);
                }
            };
            self.showPasswordHandler_wep = function (){
                $("#pwdWepKey").parent().find(".error").hide();							
                var checkbox = $("#showPassword_wep:checked");
                if(checkbox && checkbox.length == 0){
                    self.showPassword_wep(true);
                }else{
                    self.showPassword_wep(false);
                }
            }			
            /**
             * SSID2密码显示事件
             *
             * @event m_showPasswordHandler
             */
            self.m_showPasswordHandler = function () {
                $("#m_passShow").parent().find(".error").hide();
                var checkbox = $("#m_showPassword:checked");
                if (checkbox && checkbox.length == 0) {
                    self.m_showPassword(true);
                } else {
                    self.m_showPassword(false);
                }
            };

			 /**
             * SSID1二维码显示事件
             *
             * @event showQrCodeHandler
             */
			self.showQrCodeHandler = function () {
                $("#showQrCode").parent().find(".error").hide();
                var checkbox = $("#showQrCode:checked");
                if (checkbox && checkbox.length == 0) {
                    self.showQrCode(true);
                } else {
                    self.showQrCode(false);
                }
            };
			
			 /**
             * SSID1二维码显示事件
             *
             * @event m_showQrCodeHandler
             */
			self.m_showQrCodeHandler = function () {
                $("#m_showQrCode").parent().find(".error").hide();
                var checkbox = $("#m_showQrCode:checked");
                if (checkbox && checkbox.length == 0) {
                    self.m_showQrCode(true);
                } else {
                    self.m_showQrCode(false);
                }
            };

            function getRQCodeImage(isSSID1){
                if(self.supportQrCode()){
                    var timestamp = new Date().getTime();
                    if (isSSID1) {
                        return './img/qrcode_ssid_wifikey.png?_=' + timestamp;
                    } else if (config.HAS_MULTI_SSID) {
                        return './img/qrcode_multi_ssid_wifikey.png?_=' + timestamp;
                    } else {
                        return './img/menu_normal1.png';
                    }
                } else {
                    return './img/menu_normal1.png';
                }
            }

	    /****** Special For 8200 ***********/
            /**
             * 保存Wi-Fi开关的设置
             *
             * @event saveWiFiSwitch
             */
            self.saveWiFiSwitch = function () {
                var status = getWpsInfo();
                if (status.wpsFlag == '1') {
                    showAlert('wps_on_info');
                    return true;
                }

                showLoading();
                var params = {};
                if(config.WIFI_SWITCH_SUPPORT) {
                    params.wifi_switch_option = self.wifi_enable();
                }

                service.setWifiSwitch(params, function (result) {
                    if (result.result == "success") {
                        successOverlay();
                        self.clear();
                    } else {
                        errorOverlay();
                    }
                });
            };
        }

        self.m_showPasswordHandler_wep = function (){
                $("#m_pwdWepKey").parent().find(".error").hide();							
                var checkbox = $("#m_showPassword_wep:checked");
                if (checkbox && checkbox.length == 0) {
                    self.m_showPassword_wep(true);
                } else {
                    self.m_showPassword_wep(false);
                }
            }

        /**
         * 获取wifi基本信息
         * @method getWifiBasic
         * @return {Object}
         */
        function getWifiBasic() {
            return service.getWifiBasic();
        }

        /**
         * 获取wps信息
         * @method getWpsInfo
         */
        function getWpsInfo() {
            return service.getWpsInfo();
        }

        /***** Special For 8200 *********/
	/**
         * 增加ssid不能重名的判断
         * @method checkSameSSID
         * @return {Object}
         */
        function checkSameSSID(ssid1,ssid2) {
            var vm = new WifiBasicVM();
            if (config.HAS_MULTI_SSID && vm.multi_ssid_enable() == "1") {
                if(ssid1 == ssid2) {
                    showAlert("multi_ssid_same");
                    return false;
                }
            }
            return true;
        }

        /**
         * 初始化wifi基本view model
         * @method init
         */
        function init() {
            var container;
            if (config.TestMode) {
                container = $('#basic_all');
            } else {
                container = $('#container');
            }
            ko.cleanNode(container[0]);
            var vm = new WifiBasicVM();
            ko.applyBindings(vm, container[0]);

            function checkWifiStatus() {
                var info = service.getAPStationBasic();
                if (info.ap_station_enable == "1") {
                    $('#frmMultiSSID :input').each(function () {
                        $(this).attr("disabled", true);
                    });
                } else {
                    $('#frmMultiSSID :input').each(function () {
                        $(this).attr("disabled", false);
                    });
                }
            }

            if (config.AP_STATION_SUPPORT) {
                checkWifiStatus();
            }
            //clearTimer();
            //addInterval(checkWifiStatus, 1000);

            $('#frmMultiSSID').validate({
                submitHandler:function () {
                    vm.setMultiSSIDSwitch();
                }
            });
            $('#frmSSID1').validate({
                submitHandler:function () {
		            //*Special* Add for MF65 SSID1 and SSID2 can't have same name
                    if(!checkSameSSID($("#ssid").val(),$("#m_ssid").val())) {
                        return false;
                    };
                    vm.saveSSID1();
                },
                rules:{
                    ssid:'ssid',
                    txtWepKey:"wifi_wep_password_check",
                    pwdWepKey:"wifi_wep_password_check",					
                    pass:'wifi_password_check',
                    passShow:'wifi_password_check'
                },
                errorPlacement:function (error, element) {
                    var id = element.attr("id");
                    if (id == "pwdWepKey" || id == "txtWepKey") {
                        error.insertAfter("#lblShowPassword_wep");
                    }					
                    else if (id == "pass" || id == "passShow") {
                        error.insertAfter("#lblShowPassword");
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
            $('#frmSSID2').validate({
                submitHandler:function () {
	            //*Special* Add for MF65 SSID1 and SSID2 can't have same name
                    if(!checkSameSSID($("#ssid").val(),$("#m_ssid").val())) {
                        return false;
                    };
                    vm.saveSSID2();
                },
                rules:{
                    m_ssid:'ssid',
                    m_txtWepKey:"wifi_wep_password_check",
                    m_pwdWepKey:"wifi_wep_password_check",						
                    m_pass:'wifi_password_check',
                    m_passShow:'wifi_password_check'
                },
                errorPlacement:function (error, element) {
                    var id = element.attr("id");
                    if (id == "m_pwdWepKey" || id == "m_txtWepKey") {
                        error.insertAfter("#m_lblShowPassword_wep");
                    }						
                    else if (id == "m_pass" || id == "m_passShow") {
                        error.insertAfter("#m_lblShowPassword");
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
	    //*Special* Just for MF70
            $('#frmWifiSwitch').validate({
                submitHandler:function () {
                    vm.saveWiFiSwitch();
                }
            });
        }

        return {
            init:init
        };
    });