/**
 * @module prot_forward
 * @class prot_forward
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore', 'router' ],

    function($, ko, config, service, _, router) {
        var columnsTmpl = [
            { columnType:"checkbox", rowText:"index", width:"10%" },
            { headerTextTrans:"mac_address", rowText:"macAddress", width:"60%" },
            { headerTextTrans:"", rowText:"", width:"30%" }
        ];
		
        /**
         * white_list VM
         * @class WhiteListVM
         */
        function WhiteListVM() {

            var self = this;
            self.deviceInfo = ko.observableArray();
			var info = getWhiteSwitch();
            var info2 = service.getCurrentUser();
			self.client_mac_address = ko.observable('');
			fixWhiteList(self);
			
            self.macAddress = ko.observable('');
            self.macAddressName = ko.observable('');
            self.whiteListEnable = ko.observable(info.ACL_mode);
            self.oriWhiteListEnable = ko.observable(info.ACL_mode);
            self.currentWhiteList = ko.observable(info.mac_filter_white_list);
            /**
             * 设定,新增,删除回调函数
             * @method callback
             */
            self.callback = function(result) {
                if (result.result == "success") {
                    clear();
                    init(self);
					successOverlay();
					/*router.loadResources({path: 'wifi/white_list'},function(){
						$('#switch_apply_id').focus();
					});*/
                } else {
                    errorOverlay();
                }
            };

            /**
             * 情况添加规则输入
             * @method clear
             */
            function clear() {
                self.macAddress('');
                self.macAddressName('');
            }

            /**
             * 提交白名单开关
             * @method
             */
            self.setWhiteSwitch = function() {
                var status = service.getWpsInfo()
                if (status.wpsFlag == '1') {
                    showAlert('wps_on_info');
                    return;
                }
                showLoading();
                var params = {};
				var white_list = '';
                //client_mac_address板侧上报形式是 mac地址,主机名
                var cunrrentMac = self.client_mac_address().split(",")[0];
				if(self.currentWhiteList().indexOf(cunrrentMac) != -1){
                    white_list = self.currentWhiteList();
                } else if(self.currentWhiteList().split(';').length >= 10){
                    var tempList = self.currentWhiteList().split(";");
                    var tempAllList;
                    for(i=0;i<tempList.length-2;i++) {
                        tempAllList = tempAllList + tempList[i] +";";
                    }
					white_list = self.client_mac_address() +';'+ tempAllList;
				} 
				else {
					white_list = self.client_mac_address() +';'+ self.currentWhiteList();
				}
				
				params.macFilteringMode = self.whiteListEnable();
				params.white_list = white_list;
				
                service.setWhiteSwitch(params, function(result) {
					if (result.result == "success") {
						clear();
						init(self);
						successOverlay();
						/*router.loadResources({path: 'wifi/white_list'},function(){
							$('#switch_apply_id').focus();
						});*/
					} else {
						errorOverlay();
					}
				});
            };

            /**
             * 保存规则
             * @method save
             */
            self.save = function() {
                var status = service.getWpsInfo()
                if(self.currentWhiteList().indexOf(self.macAddress()) != -1){
                    showAlert("rule_exist");
                    return;
                }
				if(self.currentWhiteList().split(';').length > 10){
					showAlert("rule_max_note");
                    return;
				}
                if (status.wpsFlag == '1') {
                    showAlert('wps_on_info');
                    return;
                }
                showLoading();
                var params = {};
				params.macFilteringMode = self.whiteListEnable();
				if(self.currentWhiteList()){
					params.white_list = self.currentWhiteList() + self.macAddress()+","+self.macAddressName() + ";";
				} else {
					params.white_list = self.macAddress()+","+self.macAddressName() + ";";
				}
                
                service.setWhiteSwitch(params, function(result) {
					if (result.result == "success") {
						clear();
						init(self);
						successOverlay();
						/*router.loadResources({path: 'wifi/white_list'},function(){
							$('#MAC_input_apply_id').focus();
						});*/
					} else {
						errorOverlay();
					}
				});
            };

            /**
             * 删除规则
             * @method deleteForwardRules
             */
            self.deleteWhiteList = function(thisMac,thisHostname) {
                var status = service.getWpsInfo()
                if (status.wpsFlag == '1') {
                    showAlert('wps_on_info');
                    return;
                }
                showConfirm("confirm_data_delete", function () {
                    showLoading('deleting');
                    var params = {};
					params.macFilteringMode = self.whiteListEnable();
                    var tempMac = thisMac +"," + thisHostname + ";";
					var tempCurrentWhiteList = self.currentWhiteList() + ";";
					var tempCurrentWhiteList2 = tempCurrentWhiteList.replace(tempMac,"");
                    params.white_list = tempCurrentWhiteList2.substring(0,tempCurrentWhiteList2.length-1);
                    service.setWhiteSwitch(params, function(result) {
						if (result.result == "success") {
							clear();
							init(self);
							successOverlay();
							/*router.loadResources({path: 'wifi/white_list'},function(){
								$('.notes-title:first a:visible', '#container').focus();
							});*/
						} else {
							errorOverlay();
						}
					});
                });
            };
        }

        deleteWhiteListRules = function(thisMac,thisHostname) {
//            var vm = new WhiteListVM();
            vm.deleteWhiteList(thisMac,thisHostname);
        };
		
		function fixAttachedDevicesInfo(mac_filter_white_list, model) {
			var tempList = [];
			var deviceArr = [];
			if(mac_filter_white_list && mac_filter_white_list.length>0){
				tempList = mac_filter_white_list.split(';');
			}
			for(var i = 0; tempList && i < tempList.length; i++ ){
				var obj = {};
				obj.macAddress = tempList[i];
				
				
				deviceArr.push(obj);
			}
			//return deviceArr;
		}

        /**
         * 获取port forward信息
         * @method getWhiteSwitch
         */
        function getWhiteSwitch() {
            return service.getWhiteSwitch();
        }

        function getMacHost(){
            var whiteListInfo = service.getWhiteSwitch();
            var tempNameMac = [];
            var allMac;
            var allHostName;
            if(whiteListInfo.length > 0){
                tempNameMac = whiteListInfo.substring(0,whiteListInfo.length-1).split(';');
            }

            for(var i = 0; tempNameMac && i < tempNameMac.length; i++ ){
                var obj = {};
                allMac = allMac + tempNameMac[i].split(',')[0];
                obj.hostName = tempNameMac[i].split(',')[1];
            }
        }

		function fixWhiteList(model){
			var whiteListArr = [];
			var hostNameInfo = [];
            var macAddr = [];
			var whiteListInfo = service.getWhiteSwitch().mac_filter_white_list;
            var info2 = service.getCurrentUser();
			var tempList = [];
            var tempNameMac = [];
            if(whiteListInfo.length > 0){
                tempNameMac = whiteListInfo.substring(0,whiteListInfo.length-1).split(';');
            }

            for(var i = 0; tempNameMac && i < tempNameMac.length; i++ ){
                var obj = {};
                obj.macAddress = tempNameMac[i].split(',')[0];
                obj.hostName = tempNameMac[i].split(',')[1];
                var cunrrentMac = info2.client_mac_address.split(",")[0];
                if(cunrrentMac){
                    obj.whiteListEnabled = obj.macAddress.indexOf(cunrrentMac) == -1 ? true : false;
                } else {
                    obj.whiteListEnabled = true;
                };
                whiteListArr.push(obj);
            }
			model.deviceInfo(whiteListArr);
			$("#tabStation input").translate();
			model.client_mac_address(info2.client_mac_address);
		}

        /**
         * 初始化port forward view model
         * @method init
         */
        var vm;
        function init(viewModel) {

            if(viewModel) {
                vm = viewModel;
				var info = getWhiteSwitch();
				fixWhiteList(vm);

                vm.whiteListEnable(info.ACL_mode);
                vm.oriWhiteListEnable(info.ACL_mode);
                vm.currentWhiteList(info.mac_filter_white_list);
                
                return;
            }
            var container;
            vm = new WhiteListVM();
            vm.currentWhiteList(service.getWhiteSwitch().mac_filter_white_list);
            if (config.TestMode) {
                container = $('#white_all');
            } else {
                container = $('#container');
            }
            ko.cleanNode(container[0]);
            ko.applyBindings(vm, container[0]);

            fixTableHeight();
            renderCheckbox();

            $('#whiteListForm').validate({
                submitHandler : function() {
                    vm.setWhiteSwitch();
                }
            });

            $('#whiteListListForm').validate({
                submitHandler : function() {
                    vm.deleteForwardRules();
                }
            });

            $('#setWhiteListForm').validate({
                submitHandler : function() {
                    vm.save();
                },
                rules: {
                    txtMacAddress: {
                        white_list_optional: true,
                        mac_check: true
                    },
                    txtMacAddrName : 'white_list_name_check'
                },

                errorPlacement: function(error, element) {
                    if(element.attr("name") == "txtMacAddress") {
                        error.insertAfter("#macExamLabel");
                    }
                    else
                        error.insertAfter(element);
                }
            });
        }

        $.validator.addMethod("white_list_optional", function (value, element, param) {
            var result = _.any(['#txtMacAddress'],
                function(item) {
                    return $(item+':visible').length > 0 && $(item).val() != '';
                }
            );

            return result;
        });

        return {
            init : init
        };
    });