/**
 * restart 模块
 * @module restart
 * @class restart
 */

define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore' ],

    function ($, ko, config, service, _) {
        /**
         * RestartVM
         * @class RestartVM
         */
        function RestartVM() {
            var self = this;
            /**
             * 重启
             * @event restart
             */
            self.restart = function () {
//                var connectStatus = service.getConnectionInfo().connectStatus;
//                if (checkConnectedStatus(connectStatus)) {
//                    showAlert("restart_when_connected");
//                    return;
//                }
                showConfirm("restart_confirm", function () {
                    showLoading("restarting");
                    service.restart({}, function (data) {
                        if (data && data.result == "success") {
                            successOverlay();
                        } else {
                            errorOverlay();
                        }
                    }, $.noop);
                });
            }
        }

        /**
         * 初始化 ViewModel，并进行绑定
         * @method init
         */
        function init() {
            var vm = new RestartVM();
            var container
            if (config.TestMode) {
                container = $('#restart_all');
            } else {
                container = $('#container');
            }
            ko.applyBindings(vm, container[0]);

            $('#frmRestart').validate({
                submitHandler:function () {
                    vm.restart();
                }
            });
        }

        return {
            init:init
        }
    });
