/**
 * @module wifi basic
 * @class wifi basic
 */
define([ 'jquery', 'knockout', 'config/config', 'service', 'underscore' ],

    function ($, ko, config, service, _) {
        var ethernetDialMode = _.map(config.EthernetDialMode, function (item) {
            return new Option(item.name, item.value);
        });

        /**
         * ethernet dial view model
         * @class EthernetDialVM
         */
        function EthernetDialVM() {
            var self = this;
            var info = getEthernetInfo();

            self.isHasEthernet = ko.observable(info.cur_netcable_mode == "1");
            self.isSaveInfo = ko.observable(info.pppoe_psw_save == "1");
            self.selectedDailMode = ko.observable(info.cable_dial_mode);
            self.cable_static_wan_ipaddr = ko.observable(info.cable_static_wan_ipaddr);
            self.cable_static_wan_netmask = ko.observable(info.cable_static_wan_netmask);
            self.cable_static_wan_gateway = ko.observable(info.cable_static_wan_gateway);
            self.cable_static_prefer_dns = ko.observable(info.cable_static_prefer_dns);
            self.cable_static_standby_dns = ko.observable(info.cable_static_standby_dns);
            self.pppoe_username = ko.observable(info.pppoe_username);
            self.pppoe_password = ko.observable(info.pppoe_password);
            self.pppoe_psw_save = ko.observable(info.pppoe_psw_save);
            self.pppoe_status_word = ko.observable(setEthConnectStatus(info.pppoe_status));
            self.pppoe_status = ko.observable(info.pppoe_status);
            self.modes = ko.observableArray(ethernetDialMode);
            self.m_showPassword = ko.observable(false);
            self.pppoe_auto_dial = ko.observable(info.pppoe_auto_dial);
            self.action = ko.observable(info.pppoe_status == "ppp_connected" ? "disconnect":"connect");
            /**
             * 密码显示事件
             *
             * @event m_showPasswordHandler
             */
            self.m_showPasswordHandler = function () {
                $("#m_passShow").parent().find(".error").hide();
                var checkbox = $("#m_showPassword:checked");
                if (checkbox && checkbox.length == 0) {
                    self.m_showPassword(true);
                } else {
                    self.m_showPassword(false);
                }
            }

            self.changeSaveInfo = function () {
                var checkbox = $("#pppoe_save:checked");
                if (checkbox && checkbox.length == 0) {
                    self.isSaveInfo(true);
                } else {
                    self.isSaveInfo(false);
                }
            }

            self.clear = function (option) {
                if (option == "ethernet") {
                    self.isSaveInfo(info.pppoe_psw_save == "1");
                    self.selectedDailMode(info.cable_dial_mode);
                    self.cable_static_wan_ipaddr(info.cable_static_wan_ipaddr);
                    self.cable_static_wan_netmask(info.cable_static_wan_netmask);
                    self.cable_static_wan_gateway(info.cable_static_wan_gateway);
                    self.cable_static_prefer_dns(info.cable_static_prefer_dns);
                    self.cable_static_standby_dns(info.cable_static_standby_dns);
                    self.pppoe_username(info.pppoe_username);
                    self.pppoe_password(info.pppoe_password);

                    self.modes(ethernetDialMode);
                    self.m_showPassword(false);
                    self.pppoe_auto_dial(info.pppoe_auto_dial);
                } else {
                    clearTimer();
                    clearValidateMsg();
                    init();
                }
            };

            /**
             * 保存有线联网的设置
             *
             * @event saveEthernetPara
             */
            self.saveEthernetPara = function () {
                var msg = null;
                if (self.selectedDailMode() == "pppoe") {
                    if (checkEthConnectedStatus(self.pppoe_status())) {
                        msg = "disconnecting"
                    } else {
                        msg = "connecting"
                    }
                }
                showLoading(msg);
                var params = {};
                params.cable_dial_mode = self.selectedDailMode();
                params.mode = self.selectedDailMode();
                params.cable_static_wan_ipaddr = self.cable_static_wan_ipaddr();
                params.cable_static_wan_netmask = self.cable_static_wan_netmask();
                params.cable_static_wan_gateway = self.cable_static_wan_gateway();
                params.cable_static_prefer_dns = self.cable_static_prefer_dns();
                params.cable_static_standby_dns = self.cable_static_standby_dns();
                params.pppoe_username = self.pppoe_username();
                params.pppoe_password = self.pppoe_password();
                params.pppoe_auto_dial = self.pppoe_auto_dial();
                params.action = self.action();
                params.pppoe_psw_save = self.isSaveInfo() == true ? 1:0;
                params.pppoe_status = self.pppoe_status();


                service.setEthernetInfo(params, function (result) {
                    if (result.result == "success") {
                        successOverlay();
                        self.clear();
                    } else {
                        errorOverlay();
                    }
                });
            };
        }

        function checkEthConnectedStatus (status) {
            if (status == "ppp_connected" || status == "static_connected" || status == "dhcp_connected") {
                return true;
            } else {
                return false;
            }
        }
        /**
         * 转换联网信息
         * @method setEthConnectStatus
         * @return {Object}
         */
        function setEthConnectStatus(status) {
            var result;
            switch (status) {
                case "ppp_connected":
                    result = $.i18n.prop("connected");
                    break;
                case "dhcp_connected":
                    result = $.i18n.prop("connected");
                    break;
                case "static_connected":
                    result = $.i18n.prop("connected");
                    break;
                case "disconnected":
                    result = $.i18n.prop("disconnected");
                    break;
                default:
                    result = $.i18n.prop("disconnected");
                    break;
            }
            return result;
        }


        /**
         * 获取有线联网信息
         * @method getEthernetInfo
         * @return {Object}
         */
        function getEthernetInfo() {
            return service.getEthernetInfo();
        }

        $.validator.addMethod("subnetmask_check", function (value, element, param) {
            var result = validateNetmask(value);
            return this.optional(element) || result;
        });
        //from 4.0
        function validateNetmask(netmask) {
            var array = new Array();
            array = netmask.split(".");

            if (array.length != 4)
            {
                return false;
            }

            array[0] = parseInt(array[0]);
            array[1] = parseInt(array[1]);
            array[2] = parseInt(array[2]);
            array[3] = parseInt(array[3]);

            if (array[3] != 0)
            {
                if (array[2] != 255 || array[1] != 255 || array[0] != 255)
                {
                    return false;
                }
                else
                {
                    if (!isNetmaskIPValid(array[3]))
                    {
                        return false;
                    }
                }
            }

            if (array[2] != 0)
            {
                if (array[1] != 255 || array[0] != 255)
                {
                    return false;
                }
                else
                {
                    if (!isNetmaskIPValid(array[2]))
                    {
                        return false;
                    }
                }
            }

            if (array[1] != 0)
            {
                if (array[0] != 255)
                {
                    return false;
                }
                else
                {
                    if (!isNetmaskIPValid(array[1]))
                    {
                        return false;
                    }
                }
            }
            if(array[0]!=255)
            {
                return false;
            }
            if ( "0.0.0.0" == netmask || "255.255.255.255" == netmask)
            {
                return false;
            }

            return true;
        }

        function isNetmaskIPValid(ip) {
            if (ip == 255 || ip == 254 || ip == 252 || ip == 248
                || ip == 240 || ip == 224 || ip == 192 || ip == 128 || ip == 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        /**
         * 初始化wifi基本view model
         * @method init
         */
        function init() {
            var container = $('#container');
            ko.cleanNode(container[0]);
            var vm = new EthernetDialVM();
            ko.applyBindings(vm, container[0]);

            $('#frmEthernetConnection').validate({
                submitHandler:function () {
                    vm.saveEthernetPara();

                },
                rules:{
                    cable_static_wan_ipaddr: {
                        ip_check: true
                    },
                    cable_static_wan_netmask: {
                        subnetmask_check: true
                    },
                    cable_static_wan_gateway: {
                        ip_check: true
                    },
                    cable_static_prefer_dns: {
                        ip_check: true
                    },
                    cable_static_standby_dns: {
                        ip_check: true
                    },
                    pppoe_username : 'ppp_username_check',
                    pppoe_password : 'ppp_password_check'

                },
                errorPlacement:function (error, element) {
                    var id = element.attr("id");
                    if (id == "pppoe_passwordShow" || id == "pppoe_password") {
                        error.insertAfter("#m_lblShowPassword");
                    } else {
                        error.insertAfter(element);
                    }
                }
            });

            addInterval(function () {
                service.getEthernetInfo({}, function (data) {
                    vm.isHasEthernet(data.cur_netcable_mode == "1");
                    vm.pppoe_status_word(setEthConnectStatus(data.pppoe_status));
                });
            }, 1000);
        }

        return {
            init:init
        };
    });