define([ 'service','adm/password', 'adm/pin', 'adm/restore','adm/restart','wifi/sleep_mode','adm/display_ssid','adm/sntp' ,"adm/no_sim_card","adm/net_lock"],

    function(service, password, pin, restore,restart,power, display,sntp, no_sim, net_lock) {
        function init() {
            password.init();
            pin.init();
            no_sim.init();
            net_lock.init();
            if(service.getStatusInfo().simStatus == "modem_init_complete"){
                $("#pin_all").show();
                $("#no_sim_card").hide();
                $("#net_lock").hide();
            } else if (service.getStatusInfo().simStatus == "modem_imsi_waitnck"){
                $("#pin_all").hide();
                $("#no_sim_card").hide();
                $("#net_lock").show();
            } else {
                $("#pin_all").hide();
                $("#no_sim_card").show();
                $("#net_lock").hide();
            }
            restore.init();
            restart.init();
            power.init();
            display.init();
            sntp.init();
        }

        return {
            init: init
        };
    });