
function isRuleExist(rule)
{
	for (var i = 0; i < ruleArray.length; i++)
	{
		if (ruleArray[i] == "")
			continue;

		if (ruleArray[i] == rule)
		{
			return true;
		}
	}
	return false;
}

function isAllNumAndSlash(str)
{
	for (var i=0; i<str.length; i++){
	    if( (str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) == '.') || (str.charAt(i) == '/'))
			continue;
		return 0;
	}
	return 1;
}

function isNumOnly(str)
{
	for (var i=0; i<str.length; i++){
	    if((str.charAt(i) >= '0' && str.charAt(i) <= '9') )
			continue;
		return 0;
	}
	return 1;
}


function getProtocolType(proto)
{
	var type;
	if ("TCP" == proto)
		type = "1";
	else if ("UDP" == proto)
		type = "2";
	else if ("TCP&UDP" == proto)
		type = "3";
	else if ("ICMP" == proto)
		type = "4";
	else if ("None" == proto)
		type = "5";
		
	return type;
}


function isCharacterValid(value)
{
	var   reg   =   /[\u4E00-\u9FA5]|[\uFE30-\uFFA0]/gi;   
    if (reg.test(value))
	{
      return   false;   
    }   
    return   true;   
}


function checkRange(str, num, min, max)
{
    d = atoi(str,num);
    if(d > max || d < min)
        return false;
    return true;
}


function deleteClick(id)
{
	var isCheck = false;
	for (var i = 0; i < 10; i++)
	{
		if (document.getElementById("delRule" + i) && document.getElementById("delRule" + i).checked)
		{
			isCheck = true;
			break;
		}
	}

	if (!isCheck)
	{
		alert(Get_string("Please select the rule"));
		return false;
	}
	
	if (!confirm(Get_string("delete sure")))
	{
		return false;
	}
	
	writeHiddenNum(id);
    return true;
}


function atoi(str, num)
{
	i=1;
	if(num != 1 ){
		while (i != num && str.length != 0){
			if(str.charAt(0) == '.'){
				i++;
			}
			str = str.substring(1);
		}
	  	if(i != num )
			return -1;
	}
	
	for(i=0; i<str.length; i++){
		if(str.charAt(i) == '.'){
			str = str.substring(0, i);
			break;
		}
	}
	if(str.length == 0)
		return -1;
	if(('0' == str.charAt(0)) && (1 != str.length))
	    return -1;
		
	return parseInt(str, 10);
}


function isAllNum(str)
{
	var LastChar='.';
	for (var i=0; i<str.length; i++)
	{
		if((str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) == '.' ))
		{
			if( ('.' == LastChar) && ('0' == str.charAt(i)) )
			{
				if( (i!=0) && (i < str.length-1)  )
				{
					if('.' == str.charAt(i+1))
					{
					}						
					else return 0;
				}
				else return 0;
			}
			LastChar = str.charAt(i);
			continue;
		}
		return 0;
	}
	return 1;
}

function isInt(str)
{
	if(str.indexOf('.')==-1)
	{
		return 1;
	}
	else
	{
		return 0;
	}
	
}

function checkIpAddr(field)
{
	if(field.value == "")
		return false;

	if (isAllNumAndSlash(field.value) == 0){
		return false;
	}
	
	var fields = field.value.split('.');
	if (fields.length != 4)
	{
        return false;
	}

	var ip_pair = new Array();
	ip_pair = field.value.split("/");

	if(ip_pair.length > 2){
		return false;
	}

	if(ip_pair.length == 2){
		// sub mask
		if(!ip_pair[1].length)
			return false;
		if(!isNumOnly(ip_pair[1])){
			return false;
		}
		tmp = parseInt(ip_pair[1], 10);
		if(tmp < 0 || tmp > 32){
			return false;
		}
	}

    if( (!checkRange(ip_pair[0],1,1,223)) ||
		(!checkRange(ip_pair[0],2,0,255)) ||
		(!checkRange(ip_pair[0],3,0,255)) ||
		(!checkRange(ip_pair[0],4,1,254)) ){
		return false;
    }
	return true;
}


function display_on()
{
  if(window.XMLHttpRequest){ // Mozilla, Firefox, Safari,...
    return "table-row";
  } else if(window.ActiveXObject){ // IE
    return "block";
  }
}


function disableTextField (field)
{
  if(document.all || document.getElementById)
    field.disabled = true;
  else {
    field.oldOnFocus = field.onfocus;
    field.onfocus = skip;
  }
}

function enableTextField (field)
{
  if(document.all || document.getElementById)
    field.disabled = false;
  else {
    field.onfocus = field.oldOnFocus;
  }
}

